/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.worldgen;

import gregtech.api.util.GTLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class TemplateManager {
    private static final Map<ResourceLocation, Template> templateMap = new HashMap<ResourceLocation, Template>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Template getBuiltinTemplate(World world, ResourceLocation templateId) {
        if (templateMap.containsKey(templateId)) {
            return templateMap.get(templateId);
        }
        Template template = new Template();
        String resourcePath = "/assets/" + templateId.func_110624_b() + "/structures/" + templateId.func_110623_a() + ".nbt";
        InputStream inputStream = TemplateManager.class.getResourceAsStream(resourcePath);
        if (inputStream != null) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
                    nbttagcompound.func_74768_a("DataVersion", 500);
                }
                DataFixer dataFixer = world.func_73046_m().getDataFixer();
                template.func_186256_b(dataFixer.func_188257_a((IFixType)FixTypes.STRUCTURE, nbttagcompound));
            }
            catch (IOException exception) {
                GTLog.logger.error("Failed to load builtin template {}", (Object)templateId, (Object)exception);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        } else {
            GTLog.logger.warn("Failed to find builtin structure with path {}", (Object)resourcePath);
        }
        templateMap.put(templateId, template);
        return template;
    }

    public static BlockPos calculateAverageGroundLevel(World worldIn, BlockPos origin, BlockPos sizes) {
        BlockPos dest = origin.func_177982_a(sizes.func_177958_n(), 0, sizes.func_177952_p());
        int minGroundLevel = 256;
        for (BlockPos.MutableBlockPos blockPos : BlockPos.MutableBlockPos.func_177975_b((BlockPos)origin, (BlockPos)dest)) {
            int groundLevel = worldIn.func_175672_r((BlockPos)blockPos).func_177956_o();
            minGroundLevel = Math.min(minGroundLevel, groundLevel);
        }
        return new BlockPos(origin.func_177958_n(), minGroundLevel, origin.func_177952_p());
    }
}

