/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.util;

import com.google.common.base.Preconditions;
import gregtech.GregTechMod;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ResourcePackFix {
    private static AbstractResourcePack getModResourcePack(String modid) {
        AbstractResourcePack resourcePack;
        IResourcePack rawPack = FMLClientHandler.instance().getResourcePackFor(modid);
        if (rawPack instanceof LegacyV2Adapter) {
            resourcePack = (AbstractResourcePack)ObfuscationReflectionHelper.getPrivateValue(LegacyV2Adapter.class, (Object)((LegacyV2Adapter)rawPack), (int)0);
        } else if (rawPack instanceof AbstractResourcePack) {
            resourcePack = (AbstractResourcePack)rawPack;
        } else {
            throw new UnsupportedOperationException("Unknown resource pack class " + rawPack.getClass());
        }
        return resourcePack;
    }

    private static void setModResourcePack(String modid, AbstractResourcePack newPack) {
        FMLClientHandler clientHandler = FMLClientHandler.instance();
        IResourcePack oldPack = clientHandler.getResourcePackFor(modid);
        Map resourcePackMap = (Map)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String)"resourcePackMap");
        resourcePackMap.put(modid, newPack);
        List resourcePackList = (List)ObfuscationReflectionHelper.getPrivateValue(FMLClientHandler.class, (Object)clientHandler, (String)"resourcePackList");
        resourcePackList.remove(oldPack);
        resourcePackList.add(newPack);
    }

    private static File getGTCEResourcePackRoot() {
        URL mcModURL = GregTechMod.class.getResource("/mcmod.info");
        Preconditions.checkState((boolean)mcModURL.getProtocol().equals("file"), (Object)"Protocol is not file");
        return new File(mcModURL.getPath()).getParentFile();
    }

    public static void fixResourcePackLocation(ModContainer selfContainer) {
        File sourceFile = selfContainer.getSource();
        if (sourceFile.isDirectory()) {
            AbstractResourcePack resourcePack = ResourcePackFix.getModResourcePack(selfContainer.getModId());
            File actualPackRoot = (File)ObfuscationReflectionHelper.getPrivateValue(AbstractResourcePack.class, (Object)resourcePack, (String)"field_110597_b");
            File expectedPackRoot = ResourcePackFix.getGTCEResourcePackRoot();
            if (!expectedPackRoot.getAbsolutePath().equals(actualPackRoot.getAbsolutePath())) {
                System.out.println("[GTCE] Found unexpected resource pack path in dev environment");
                System.out.println("[GTCE] Expected path: " + expectedPackRoot.getAbsolutePath());
                System.out.println("[GTCE] Actual path: " + actualPackRoot.getAbsolutePath());
                System.out.println("[GTCE] Fixed resource pack patch automatically.");
                ObfuscationReflectionHelper.setPrivateValue(AbstractResourcePack.class, (Object)resourcePack, (Object)expectedPackRoot, (String)"field_110597_b");
                ResourcePackFix.setModResourcePack(selfContainer.getModId(), resourcePack);
            }
        }
    }
}

