/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.tesr;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import gregtech.api.render.Textures;
import gregtech.common.blocks.BlockCrusherBlade;
import gregtech.common.blocks.tileentity.TileEntityCrusherBlade;
import gregtech.common.render.tesr.TileEntityRendererBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class TileEntityCrusherBladeRenderer
extends TileEntityRendererBase<TileEntityCrusherBlade> {
    @Override
    protected void draw(TileEntityCrusherBlade tileEntity, CCRenderState renderState, Matrix4 translation, float partialTicks) {
        translation.translate(0.5, 0.5, 0.5);
        IBlockState blockState = tileEntity.getBlockState();
        switch ((EnumFacing.Axis)blockState.func_177229_b(BlockCrusherBlade.AXIS)) {
            case Y: {
                break;
            }
            case X: {
                translation.rotate(Math.toRadians(90.0), Rotation.axes[3]);
                break;
            }
            case Z: {
                translation.rotate(Math.toRadians(90.0), Rotation.axes[5]);
            }
        }
        if (((Boolean)blockState.func_177229_b((IProperty)BlockCrusherBlade.ACTIVE)).booleanValue()) {
            long currentWorldTime = tileEntity.func_145830_o() ? tileEntity.func_145831_w().func_82737_E() : 0L;
            translation.rotate(Math.toRadians((double)currentWorldTime * 12.0 % 180.0), Rotation.axes[1]);
        }
        translation.translate(-0.5, -0.5, -0.5);
        TextureAtlasSprite ironBlockTexture = TextureUtils.getBlockTexture((String)"iron_block");
        IVertexOperation[] operations = new IVertexOperation[]{};
        for (Cuboid6 cuboid6 : BlockCrusherBlade.basicModel) {
            for (EnumFacing renderSide : EnumFacing.field_82609_l) {
                Textures.renderFace(renderState, translation, operations, renderSide, cuboid6, ironBlockTexture);
            }
        }
    }
}

