/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.surfacerock.BlockSurfaceRock;
import gregtech.common.blocks.surfacerock.BlockSurfaceRockNew;
import gregtech.common.blocks.surfacerock.TileEntitySurfaceRock;
import gregtech.common.render.StonePileModelGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class StoneRenderer
implements ICCBlockRenderer {
    private static final StoneRenderer INSTANCE = new StoneRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private static CCModel[] placeholderModels;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_stone");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        Random random = new Random();
        StoneRenderer.placeholderModels[0] = StoneRenderer.generateModel(random);
    }

    private static CCModel generateModel(Random random) {
        return StonePileModelGenerator.generatePebblePileModel(random);
    }

    private static CCModel getActualModel(IBlockAccess world, BlockPos pos) {
        TileEntitySurfaceRock tileEntity = BlockSurfaceRockNew.getTileEntity(world, pos);
        if (tileEntity != null) {
            if (tileEntity.cachedModel == null) {
                Random random = new Random(MathHelper.func_180186_a((Vec3i)pos));
                tileEntity.cachedModel = StoneRenderer.generateModel(random);
            }
            return (CCModel)tileEntity.cachedModel;
        }
        return placeholderModels[0];
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        Matrix4 translation = new Matrix4();
        translation.translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        TextureAtlasSprite stoneSprite = TextureUtils.getBlockTexture((String)"stone");
        Material material = ((BlockSurfaceRock)state.func_177230_c()).getStoneMaterial(world, pos, state);
        int renderingColor = GTUtility.convertRGBtoOpaqueRGBA_CL(material.materialRGB);
        IVertexOperation[] operations = new IVertexOperation[]{new IconTransformation(stoneSprite), new ColourMultiplier(renderingColor), new TransformationList(new Transformation[]{translation})};
        if (world != null) {
            renderState.setBrightness(world, pos);
        }
        renderState.setPipeline(operations);
        CCModel actualModel = StoneRenderer.getActualModel(world, pos);
        renderState.setModel((IVertexSource)actualModel);
        renderState.render();
        return true;
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        Cuboid6 baseBox = new Cuboid6(state.func_185900_c(world, pos));
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
    }

    public void renderBrightness(IBlockState state, float brightness) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.renderBlock(null, BlockPos.field_177992_a, state, tessellator.func_178180_c());
        tessellator.func_78381_a();
    }

    public void registerTextures(TextureMap map) {
    }

    static {
        placeholderModels = new CCModel[1];
    }
}

