/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.simple.EmptyNodeData;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.common.pipelike.inventory.BlockInventoryPipe;
import gregtech.common.pipelike.inventory.InventoryPipeType;
import gregtech.common.pipelike.inventory.tile.TileEntityInventoryPipe;
import gregtech.common.render.ShapeModelGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class InvPipeRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "inv_pipe"), "normal");
    public static InvPipeRenderer INSTANCE = new InvPipeRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private TextureAtlasSprite jointTextureSprite;
    private TextureAtlasSprite pipeTextureSprite;
    private CCModel[] fullBlockVariants;
    private CCModel[] connectionModels;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_inv_pipe");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(INSTANCE::registerIcons);
    }

    public void registerIcons(TextureMap map) {
        this.jointTextureSprite = map.func_174942_a(new ResourceLocation("gregtech", "blocks/inv_pipe/joint"));
        this.pipeTextureSprite = map.func_174942_a(new ResourceLocation("gregtech", "blocks/inv_pipe/pipe"));
        InventoryPipeType pipeType = InventoryPipeType.NORMAL;
        float thickness = pipeType.getThickness();
        double height = (1.0f - thickness) / 2.0f;
        CCModel connectionModel = ShapeModelGenerator.generateModel(3, height, thickness / 3.0f, height);
        CCModel fullBlockModel = ShapeModelGenerator.generateModel(3, 1.0, thickness / 3.0f, height);
        this.fullBlockVariants = ShapeModelGenerator.generateFullBlockVariants(fullBlockModel);
        this.connectionModels = ShapeModelGenerator.generateRotatedVariants(connectionModel);
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack rawItemStack, ItemCameraTransforms.TransformType transformType) {
        GlStateManager.func_179147_l();
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        this.renderPipe(renderState, new IVertexOperation[0], 0x777777, 12);
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setBrightness(world, pos);
        IVertexOperation[] pipeline = new IVertexOperation[]{new Translation((Vec3i)pos)};
        BlockInventoryPipe block = (BlockInventoryPipe)state.func_177230_c();
        TileEntityInventoryPipe tileEntity = (TileEntityInventoryPipe)block.getPipeTileEntity(world, pos);
        if (tileEntity == null) {
            return false;
        }
        int paintingColor = tileEntity.getInsulationColor();
        int connectedSidesMask = block.getActualConnections(tileEntity, world);
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        if (renderLayer == BlockRenderLayer.SOLID) {
            this.renderPipe(renderState, pipeline, paintingColor, connectedSidesMask);
        }
        PipeCoverableImplementation coverable = tileEntity.getCoverableImplementation();
        coverable.renderCovers(renderState, new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), renderLayer);
        return true;
    }

    public void renderPipe(CCRenderState renderState, IVertexOperation[] pipeline, int insulationColor, int connectMask) {
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockInventoryPipe block = (BlockInventoryPipe)state.func_177230_c();
        TileEntityInventoryPipe tileEntity = (TileEntityInventoryPipe)block.getPipeTileEntity(world, pos);
        if (tileEntity == null) {
            return;
        }
        InventoryPipeType pipeType = (InventoryPipeType)tileEntity.getPipeType();
        if (pipeType == null) {
            return;
        }
        float thickness = pipeType.getThickness();
        int connectedSidesMask = block.getActualConnections(tileEntity, world);
        Cuboid6 baseBox = BlockPipe.getSideBox(null, thickness);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            if ((connectedSidesMask & 1 << renderSide.func_176745_a()) <= 0) continue;
            Cuboid6 sideBox = BlockPipe.getSideBox(renderSide, thickness);
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)sideBox, (int)0);
        }
    }

    public void registerTextures(TextureMap map) {
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public Pair<TextureAtlasSprite, Integer> getParticleTexture(IPipeTile<InventoryPipeType, EmptyNodeData> tileEntity) {
        if (tileEntity == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        TextureAtlasSprite atlasSprite = TextureUtils.getBlockTexture((String)"stone");
        int particleColor = tileEntity.getInsulationColor();
        return Pair.of((Object)atlasSprite, (Object)particleColor);
    }
}

