/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ModCompatibility;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.ItemBlockCable;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.tile.TileEntityCable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CableRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("gregtech", "cable"), "normal");
    public static CableRenderer INSTANCE = new CableRenderer();
    public static EnumBlockRenderType BLOCK_RENDER_TYPE;
    private static ThreadLocal<BlockRenderer.BlockFace> blockFaces;
    private TextureAtlasSprite[] insulationTextures = new TextureAtlasSprite[6];
    private TextureAtlasSprite wireTexture;

    public static void preInit() {
        BLOCK_RENDER_TYPE = BlockRenderingRegistry.createRenderType((String)"gt_cable");
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)BLOCK_RENDER_TYPE, (ICCBlockRenderer)INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        TextureUtils.addIconRegister(INSTANCE::registerIcons);
    }

    public void registerIcons(TextureMap map) {
        GTLog.logger.info("Registering cable textures.");
        ResourceLocation wireLocation = new ResourceLocation("gregtech", "blocks/cable/wire");
        this.wireTexture = map.func_174942_a(wireLocation);
        for (int i = 0; i < this.insulationTextures.length; ++i) {
            ResourceLocation location = new ResourceLocation("gregtech", "blocks/cable/insulation_" + i);
            this.insulationTextures[i] = map.func_174942_a(location);
        }
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        GTLog.logger.info("Injected cable render model");
        event.getModelRegistry().func_82595_a((Object)MODEL_LOCATION, (Object)this);
    }

    public void renderItem(ItemStack rawItemStack, ItemCameraTransforms.TransformType transformType) {
        ItemStack stack = ModCompatibility.getRealItemStack(rawItemStack);
        if (!(stack.func_77973_b() instanceof ItemBlockCable)) {
            return;
        }
        GlStateManager.func_179147_l();
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        BlockCable blockCable = (BlockCable)((ItemBlockCable)stack.func_77973_b()).func_179223_d();
        Insulation insulation = (Insulation)blockCable.getItemPipeType(stack);
        Material material = blockCable.getItemMaterial(stack);
        if (insulation != null && material != null) {
            this.renderCableBlock(material, insulation, 0x777777, renderState, new IVertexOperation[0], 1 << EnumFacing.SOUTH.func_176745_a() | 1 << EnumFacing.NORTH.func_176745_a() | 1 << 6 + EnumFacing.SOUTH.func_176745_a() | 1 << 6 + EnumFacing.NORTH.func_176745_a());
        }
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setBrightness(world, pos);
        IVertexOperation[] pipeline = new IVertexOperation[]{new Translation((Vec3i)pos)};
        BlockCable blockCable = (BlockCable)state.func_177230_c();
        TileEntityCable tileEntityCable = (TileEntityCable)blockCable.getPipeTileEntity(world, pos);
        if (tileEntityCable == null) {
            return false;
        }
        int paintingColor = tileEntityCable.getInsulationColor();
        int connectedSidesMask = blockCable.getActualConnections(tileEntityCable, world);
        Insulation insulation = (Insulation)tileEntityCable.getPipeType();
        Material material = tileEntityCable.getPipeMaterial();
        if (insulation != null && material != null) {
            BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
            if (renderLayer == BlockRenderLayer.CUTOUT) {
                this.renderCableBlock(material, insulation, paintingColor, renderState, pipeline, connectedSidesMask);
            }
            PipeCoverableImplementation coverable = tileEntityCable.getCoverableImplementation();
            coverable.renderCovers(renderState, new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), renderLayer);
        }
        return true;
    }

    public void renderCableBlock(Material material, Insulation insulation1, int insulationColor1, CCRenderState state, IVertexOperation[] pipeline, int connectMask) {
        IVertexOperation[] wire;
        int wireColor = GTUtility.convertRGBtoOpaqueRGBA_CL(material.materialRGB);
        float thickness = insulation1.thickness;
        IVertexOperation[] overlays = wire = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(this.wireTexture), new ColourMultiplier(wireColor)});
        IVertexOperation[] insulation = wire;
        if (insulation1.insulationLevel != -1) {
            int insulationColor = GTUtility.convertRGBtoOpaqueRGBA_CL(insulationColor1);
            ColourMultiplier multiplier = new ColourMultiplier(insulationColor);
            insulation = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(this.insulationTextures[5]), multiplier});
            overlays = (IVertexOperation[])ArrayUtils.addAll((Object[])pipeline, (Object[])new IVertexOperation[]{new IconTransformation(this.insulationTextures[insulation1.insulationLevel]), multiplier});
        }
        Cuboid6 cuboid6 = BlockCable.getSideBox(null, thickness);
        for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
            if ((connectMask & 1 << renderedSide.func_176745_a()) != 0) continue;
            int oppositeIndex = renderedSide.func_176734_d().func_176745_a();
            if ((connectMask & 1 << oppositeIndex) > 0 && (connectMask & ~(1 << oppositeIndex)) == 0) {
                CableRenderer.renderCableSide(state, wire, renderedSide, cuboid6);
                CableRenderer.renderCableSide(state, overlays, renderedSide, cuboid6);
                continue;
            }
            CableRenderer.renderCableSide(state, insulation, renderedSide, cuboid6);
        }
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.DOWN, thickness);
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.UP, thickness);
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.WEST, thickness);
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.EAST, thickness);
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.NORTH, thickness);
        CableRenderer.renderCableCube(connectMask, state, insulation, wire, overlays, EnumFacing.SOUTH, thickness);
    }

    private static void renderCableCube(int connections, CCRenderState renderState, IVertexOperation[] pipeline, IVertexOperation[] wire, IVertexOperation[] overlays, EnumFacing side, float thickness) {
        if ((connections & 1 << side.func_176745_a()) > 0) {
            boolean renderFrontSide = (connections & 1 << 6 + side.func_176745_a()) > 0;
            Cuboid6 cuboid6 = BlockCable.getSideBox(side, thickness);
            for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
                if (renderedSide == side) {
                    if (!renderFrontSide) continue;
                    CableRenderer.renderCableSide(renderState, wire, renderedSide, cuboid6);
                    CableRenderer.renderCableSide(renderState, overlays, renderedSide, cuboid6);
                    continue;
                }
                if (renderedSide == side.func_176734_d()) continue;
                CableRenderer.renderCableSide(renderState, pipeline, renderedSide, cuboid6);
            }
        }
    }

    private static void renderCableSide(CCRenderState renderState, IVertexOperation[] pipeline, EnumFacing side, Cuboid6 cuboid6) {
        BlockRenderer.BlockFace blockFace = blockFaces.get();
        blockFace.loadCuboidFace(cuboid6, side.func_176745_a());
        renderState.setPipeline((IVertexSource)blockFace, 0, blockFace.verts.length, pipeline);
        renderState.render();
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockCable blockCable = (BlockCable)state.func_177230_c();
        IPipeTile tileEntityCable = blockCable.getPipeTileEntity(world, pos);
        if (tileEntityCable == null) {
            return;
        }
        Insulation insulation = (Insulation)tileEntityCable.getPipeType();
        if (insulation == null) {
            return;
        }
        float thickness = insulation.getThickness();
        int connectedSidesMask = blockCable.getActualConnections(tileEntityCable, world);
        Cuboid6 baseBox = BlockCable.getSideBox(null, thickness);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            if ((connectedSidesMask & 1 << renderSide.func_176745_a()) <= 0) continue;
            Cuboid6 sideBox = BlockCable.getSideBox(renderSide, thickness);
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)sideBox, (int)0);
        }
    }

    public void registerTextures(TextureMap map) {
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public Pair<TextureAtlasSprite, Integer> getParticleTexture(IPipeTile<Insulation, WireProperties> tileEntity) {
        int particleColor;
        TextureAtlasSprite atlasSprite;
        if (tileEntity == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        Material material = ((TileEntityCable)tileEntity).getPipeMaterial();
        Insulation insulation = tileEntity.getPipeType();
        if (material == null || insulation == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        if (insulation.insulationLevel == -1) {
            atlasSprite = this.wireTexture;
            particleColor = material.materialRGB;
        } else {
            atlasSprite = this.insulationTextures[5];
            particleColor = tileEntity.getInsulationColor();
        }
        return Pair.of((Object)atlasSprite, (Object)particleColor);
    }

    static {
        blockFaces = ThreadLocal.withInitial(BlockRenderer.BlockFace::new);
    }
}

