/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTFluidUtils;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPipeTickable
extends TileEntityFluidPipe
implements ITickable {
    private boolean isActive;

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void func_73660_a() {
        this.getCoverableImplementation().update();
        if (this.isActive) {
            TileEntityFluidPipeTickable.pushFluidsFromTank(this);
        }
    }

    @Override
    public boolean supportsTicking() {
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("ActiveNode", this.isActive);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isActive = compound.func_74767_n("ActiveNode");
    }

    public static void pushFluidsFromTank(IPipeTile<FluidPipeType, FluidPipeProperties> pipeTile) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        int blockedConnections = pipeTile.getBlockedConnections();
        BlockFluidPipe blockFluidPipe = (BlockFluidPipe)pipeTile.getPipeBlock();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tileEntity;
            if ((blockedConnections & 1 << side.func_176745_a()) > 0) continue;
            blockPos.func_189533_g((Vec3i)pipeTile.getPipePos()).func_189536_c(side);
            if (!pipeTile.getPipeWorld().func_175667_e((BlockPos)blockPos) || (tileEntity = pipeTile.getPipeWorld().func_175625_s((BlockPos)blockPos)) == null) continue;
            IFluidHandler sourceHandler = (IFluidHandler)pipeTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            IFluidHandler receiverHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
            if (sourceHandler == null || receiverHandler == null || !blockFluidPipe.canPushIntoFluidHandler(pipeTile, tileEntity, sourceHandler, receiverHandler)) continue;
            GTFluidUtils.transferFluids(sourceHandler, receiverHandler, Integer.MAX_VALUE);
        }
        blockPos.func_185344_t();
    }
}

