/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe.tile;

import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.tile.FluidPipeFluidHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidPipe
extends TileEntityMaterialPipeBase<FluidPipeType, FluidPipeProperties> {
    private static final Random random = new Random();
    private IFluidHandler fluidHandler;

    @Override
    public Class<FluidPipeType> getPipeTypeClass() {
        return FluidPipeType.class;
    }

    @Override
    public boolean supportsTicking() {
        return false;
    }

    protected IFluidHandler getFluidHandler() {
        if (this.fluidHandler == null) {
            this.fluidHandler = new FluidPipeFluidHandler(this);
        }
        return this.fluidHandler;
    }

    @Override
    @Nullable
    public <T> T getCapabilityInternal(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidHandler());
        }
        return super.getCapabilityInternal(capability, facing);
    }

    public static void setNeighboursToFire(World world, BlockPos selfPos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos blockPos;
            IBlockState blockState;
            if (!random.nextBoolean() || !(blockState = world.func_180495_p(blockPos = selfPos.func_177972_a(side))).func_177230_c().isAir(blockState, (IBlockAccess)world, blockPos) && !blockState.func_177230_c().isFlammable((IBlockAccess)world, blockPos, side.func_176734_d())) continue;
            world.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
        }
    }

    public static void spawnParticles(World worldIn, BlockPos pos, EnumFacing direction, EnumParticleTypes particleType, int particleCount, Random rand) {
        for (int i = 0; i < particleCount; ++i) {
            worldIn.func_175688_a(particleType, (double)pos.func_177958_n() + 0.5 - (double)direction.func_82601_c() / 1.8, (double)pos.func_177956_o() + 0.5 - (double)direction.func_96559_d() / 1.8, (double)pos.func_177952_p() + 0.5 - (double)direction.func_82599_e() / 1.8, (double)direction.func_82601_c() * 0.2 + rand.nextDouble() * 0.1, (double)direction.func_96559_d() * 0.2 + rand.nextDouble() * 0.1, (double)direction.func_82599_e() * 0.2 + rand.nextDouble() * 0.1, new int[0]);
        }
    }
}

