/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.fluidpipe;

import com.google.common.base.Preconditions;
import gregtech.api.damagesources.DamageSources;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.type.Material;
import gregtech.common.pipelike.fluidpipe.FluidPipeProperties;
import gregtech.common.pipelike.fluidpipe.FluidPipeType;
import gregtech.common.pipelike.fluidpipe.net.FluidPipeNet;
import gregtech.common.pipelike.fluidpipe.net.WorldFluidPipeNet;
import gregtech.common.pipelike.fluidpipe.tile.FluidPipeFluidHandler;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipeTickable;
import gregtech.common.render.FluidPipeRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockFluidPipe
extends BlockMaterialPipe<FluidPipeType, FluidPipeProperties, WorldFluidPipeNet> {
    private final SortedMap<Material, FluidPipeProperties> enabledMaterials = new TreeMap<Material, FluidPipeProperties>();

    public BlockFluidPipe() {
        this.setHarvestLevel("pickaxe", 1);
    }

    public void addPipeMaterial(Material material, FluidPipeProperties fluidPipeProperties) {
        Preconditions.checkNotNull((Object)material, (Object)"material");
        Preconditions.checkNotNull((Object)fluidPipeProperties, (Object)"fluidPipeProperties");
        Preconditions.checkArgument((Material.MATERIAL_REGISTRY.getNameForObject(material) != null ? 1 : 0) != 0, (Object)"material is not registered");
        this.enabledMaterials.put(material, fluidPipeProperties);
    }

    public Collection<Material> getEnabledMaterials() {
        return Collections.unmodifiableSet(this.enabledMaterials.keySet());
    }

    @Override
    public Class<FluidPipeType> getPipeTypeClass() {
        return FluidPipeType.class;
    }

    @Override
    public WorldFluidPipeNet getWorldPipeNet(World world) {
        return WorldFluidPipeNet.getWorldPipeNet(world);
    }

    @Override
    protected FluidPipeProperties createProperties(FluidPipeType fluidPipeType, Material material) {
        return fluidPipeType.modifyProperties(this.enabledMaterials.getOrDefault(material, this.getFallbackType()));
    }

    @Override
    protected FluidPipeProperties getFallbackType() {
        return this.enabledMaterials.values().iterator().next();
    }

    @Override
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Material material : this.enabledMaterials.keySet()) {
            for (FluidPipeType fluidPipeType : FluidPipeType.values()) {
                items.add((Object)this.getItem(fluidPipeType, material));
            }
        }
    }

    @Override
    protected boolean canPipesConnect(IPipeTile<FluidPipeType, FluidPipeProperties> selfTile, EnumFacing side, IPipeTile<FluidPipeType, FluidPipeProperties> sideTile) {
        return selfTile.getNodeData().equals(sideTile.getNodeData());
    }

    @Override
    protected int getActiveVisualConnections(IPipeTile<FluidPipeType, FluidPipeProperties> selfTile) {
        int activeNodeConnections = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos = selfTile.getPipePos().func_177972_a(side);
            TileEntity tileEntity = selfTile.getPipeWorld().func_175625_s(offsetPos);
            if (tileEntity == null) continue;
            EnumFacing opposite = side.func_176734_d();
            IFluidHandler sourceHandler = (IFluidHandler)selfTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            IFluidHandler receivedHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite);
            if (sourceHandler == null || receivedHandler == null) continue;
            activeNodeConnections |= 1 << side.func_176745_a();
        }
        return activeNodeConnections;
    }

    @Override
    public int getActiveNodeConnections(IBlockAccess world, BlockPos nodePos, IPipeTile<FluidPipeType, FluidPipeProperties> selfTileEntity) {
        int activeNodeConnections = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            BlockPos offsetPos = nodePos.func_177972_a(side);
            TileEntity tileEntity = world.func_175625_s(offsetPos);
            if (tileEntity == null) continue;
            EnumFacing opposite = side.func_176734_d();
            IFluidHandler sourceHandler = (IFluidHandler)selfTileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            IFluidHandler receivedHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite);
            if (sourceHandler == null || receivedHandler == null || !this.canPushIntoFluidHandler(selfTileEntity, tileEntity, sourceHandler, receivedHandler)) continue;
            activeNodeConnections |= 1 << side.func_176745_a();
        }
        return activeNodeConnections;
    }

    public boolean canPushIntoFluidHandler(IPipeTile<FluidPipeType, FluidPipeProperties> selfTileEntity, TileEntity otherTileEntity, IFluidHandler sourceHandler, IFluidHandler destinationHandler) {
        boolean isSourcePipe = sourceHandler instanceof FluidPipeFluidHandler;
        boolean isDestPipe = destinationHandler instanceof FluidPipeFluidHandler;
        if (isSourcePipe && isDestPipe) {
            float sourceThickness = selfTileEntity.getPipeType().getThickness();
            IPipeTile otherPipe = this.getPipeTileEntity(otherTileEntity);
            if (otherPipe == null) {
                return false;
            }
            float destThickness = ((FluidPipeType)otherPipe.getPipeType()).getThickness();
            return sourceThickness > destThickness;
        }
        return true;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase && entityIn.field_70170_p.func_72820_D() % 20L == 0L) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
            FluidPipeNet pipeNet = (FluidPipeNet)this.getWorldPipeNet(worldIn).getNetFromPos(pos);
            if (pipeNet != null) {
                FluidStack fluidStack = pipeNet.getFluidNetTank().getFluid();
                if (fluidStack == null) {
                    return;
                }
                int fluidTemperature = fluidStack.getFluid().getTemperature(fluidStack);
                if (fluidTemperature >= 373) {
                    float damageAmount = (float)(fluidTemperature - 363) / 4.0f;
                    entityLiving.func_70097_a(DamageSources.getHeatDamage(), damageAmount);
                } else if (fluidTemperature <= 183) {
                    float damageAmount = (float)fluidTemperature / 4.0f;
                    entityLiving.func_70097_a(DamageSources.getFrostDamage(), damageAmount);
                }
            }
        }
    }

    @Override
    public TileEntityPipeBase<FluidPipeType, FluidPipeProperties> createNewTileEntity(boolean supportsTicking) {
        return supportsTicking ? new TileEntityFluidPipeTickable() : new TileEntityFluidPipe();
    }

    @Override
    protected void onActiveModeChange(World world, BlockPos pos, boolean isActiveNow, boolean isInitialChange) {
        TileEntityFluidPipe oldTileEntity = (TileEntityFluidPipe)world.func_175625_s(pos);
        if (!(oldTileEntity instanceof TileEntityFluidPipeTickable) && isActiveNow) {
            TileEntityFluidPipeTickable newTileEntity = new TileEntityFluidPipeTickable();
            newTileEntity.transferDataFrom(oldTileEntity);
            newTileEntity.setActive(true);
            world.func_175690_a(pos, (TileEntity)newTileEntity);
        } else if (oldTileEntity instanceof TileEntityFluidPipeTickable) {
            ((TileEntityFluidPipeTickable)oldTileEntity).setActive(isActiveNow);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return FluidPipeRenderer.BLOCK_RENDER_TYPE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Pair<TextureAtlasSprite, Integer> getParticleTexture(World world, BlockPos blockPos) {
        return FluidPipeRenderer.INSTANCE.getParticleTexture((TileEntityFluidPipe)world.func_175625_s(blockPos));
    }
}

