/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.tile;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.common.pipelike.cable.Insulation;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.net.EnergyNet;
import gregtech.common.pipelike.cable.net.RoutePath;
import gregtech.common.pipelike.cable.net.WorldENet;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class CableEnergyContainer
implements IEnergyContainer {
    private final IPipeTile<Insulation, WireProperties> tileEntityCable;
    private WeakReference<EnergyNet> currentEnergyNet = new WeakReference<Object>(null);
    private long lastCachedUpdate;
    private List<RoutePath> pathsCache;

    public CableEnergyContainer(IPipeTile<Insulation, WireProperties> tileEntityCable) {
        this.tileEntityCable = tileEntityCable;
    }

    @Override
    public long acceptEnergyFromNetwork(EnumFacing side, long voltage, long amperage) {
        EnergyNet energyNet = this.getEnergyNet();
        if (energyNet == null) {
            return 0L;
        }
        List<RoutePath> paths = this.getPaths();
        long amperesUsed = 0L;
        for (RoutePath routePath : paths) {
            if ((long)routePath.totalLoss >= voltage) continue;
            BlockPos destinationPos = routePath.destination;
            int blockedConnections = energyNet.getAllNodes().get((Object)destinationPos).blockedConnections;
            amperesUsed += this.dispatchEnergyToNode(destinationPos, blockedConnections, voltage - (long)routePath.totalLoss, amperage - amperesUsed);
            if (voltage > (long)routePath.minVoltage || amperesUsed > (long)routePath.maxAmperage) {
                this.burnAllPaths(paths, voltage, amperage, amperesUsed);
                break;
            }
            if (amperesUsed != amperage) continue;
            break;
        }
        energyNet.incrementCurrentAmperage(amperage, voltage);
        return amperesUsed;
    }

    private void burnAllPaths(List<RoutePath> paths, long voltage, long amperage, long lastAmperage) {
        for (RoutePath pathToBurn : paths) {
            if (voltage <= (long)pathToBurn.minVoltage && amperage <= (long)pathToBurn.maxAmperage && lastAmperage <= (long)pathToBurn.maxAmperage) continue;
            pathToBurn.burnCablesInPath(this.tileEntityCable.getPipeWorld(), voltage, Math.max(amperage, lastAmperage));
        }
    }

    private long dispatchEnergyToNode(BlockPos nodePos, int nodeBlockedConnections, long voltage, long amperage) {
        long amperesUsed = 0L;
        World world = this.tileEntityCable.getPipeWorld();
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            IEnergyContainer energyContainer;
            TileEntity tileEntity;
            if ((nodeBlockedConnections & 1 << facing.func_176745_a()) > 0) continue;
            blockPos.func_189533_g((Vec3i)nodePos).func_189536_c(facing);
            if (world.func_175667_e(nodePos) && (tileEntity = world.func_175625_s((BlockPos)blockPos)) != null && this.tileEntityCable.getPipeBlock().getPipeTileEntity(tileEntity) == null && (energyContainer = (IEnergyContainer)tileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, facing.func_176734_d())) != null && (amperesUsed += energyContainer.acceptEnergyFromNetwork(facing.func_176734_d(), voltage, amperage - amperesUsed)) == amperage) break;
        }
        blockPos.func_185344_t();
        return amperesUsed;
    }

    @Override
    public long getInputAmperage() {
        return this.tileEntityCable.getNodeData().amperage;
    }

    @Override
    public long getInputVoltage() {
        return this.tileEntityCable.getNodeData().voltage;
    }

    @Override
    public long getEnergyCapacity() {
        return this.getInputVoltage() * this.getInputAmperage();
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        return this.acceptEnergyFromNetwork(EnumFacing.UP, energyToAdd / this.getInputVoltage(), energyToAdd / this.getInputAmperage()) * this.getInputVoltage();
    }

    @Override
    public boolean outputsEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public boolean inputsEnergy(EnumFacing side) {
        return true;
    }

    @Override
    public long getEnergyStored() {
        return 0L;
    }

    private void recomputePaths(EnergyNet energyNet) {
        this.lastCachedUpdate = energyNet.getLastUpdate();
        this.pathsCache = energyNet.computePatches(this.tileEntityCable.getPipePos());
    }

    private List<RoutePath> getPaths() {
        EnergyNet energyNet = this.getEnergyNet();
        if (energyNet == null) {
            return Collections.emptyList();
        }
        if (this.pathsCache == null || energyNet.getLastUpdate() > this.lastCachedUpdate) {
            this.recomputePaths(energyNet);
        }
        return this.pathsCache;
    }

    private EnergyNet getEnergyNet() {
        EnergyNet currentEnergyNet = (EnergyNet)this.currentEnergyNet.get();
        if (currentEnergyNet != null && currentEnergyNet.isValid() && currentEnergyNet.containsNode(this.tileEntityCable.getPipePos())) {
            return currentEnergyNet;
        }
        WorldENet worldENet = (WorldENet)((Object)this.tileEntityCable.getPipeBlock().getWorldPipeNet(this.tileEntityCable.getPipeWorld()));
        currentEnergyNet = (EnergyNet)worldENet.getNetFromPos(this.tileEntityCable.getPipePos());
        if (currentEnergyNet != null) {
            this.currentEnergyNet = new WeakReference<EnergyNet>(currentEnergyNet);
        }
        return currentEnergyNet;
    }

    @Override
    public boolean isOneProbeHidden() {
        return true;
    }
}

