/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.util.PerTickLongCounter;
import gregtech.common.pipelike.cable.WireProperties;
import gregtech.common.pipelike.cable.net.RoutePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class EnergyNet
extends PipeNet<WireProperties> {
    private final PerTickLongCounter currentAmperageCounter = new PerTickLongCounter(0L);
    private final PerTickLongCounter currentMaxVoltageCounter = new PerTickLongCounter(0L);

    protected EnergyNet(WorldPipeNet<WireProperties, EnergyNet> world) {
        super(world);
    }

    public long getLastAmperage() {
        return this.currentAmperageCounter.getLast(this.worldData.getWorld());
    }

    public long getLastMaxVoltage() {
        return this.currentMaxVoltageCounter.getLast(this.worldData.getWorld());
    }

    public void incrementCurrentAmperage(long amperage, long voltage) {
        this.currentAmperageCounter.increment(this.worldData.getWorld(), amperage);
        long currentMaxVoltage = this.currentMaxVoltageCounter.get(this.worldData.getWorld());
        if (voltage > currentMaxVoltage) {
            this.currentMaxVoltageCounter.set(this.worldData.getWorld(), voltage);
        }
    }

    public List<RoutePath> computePatches(BlockPos startPos) {
        ArrayList<RoutePath> readyPaths = new ArrayList<RoutePath>();
        RoutePath currentPath = new RoutePath();
        Node firstNode = this.getNodeAt(startPos);
        currentPath.path.put(startPos, (WireProperties)firstNode.data);
        readyPaths.add(currentPath.cloneAndCompute(startPos));
        HashSet<BlockPos> observedSet = new HashSet<BlockPos>();
        observedSet.add(startPos);
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(startPos);
        Stack<EnumFacing> moveStack = new Stack<EnumFacing>();
        while (true) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                currentPos.func_189536_c(facing);
                Node secondNode = this.getNodeAt((BlockPos)currentPos);
                if (secondNode != null && this.canNodesConnect(firstNode, facing, secondNode, this) && !observedSet.contains(currentPos)) {
                    BlockPos immutablePos = currentPos.func_185334_h();
                    observedSet.add(immutablePos);
                    firstNode = secondNode;
                    moveStack.push(facing.func_176734_d());
                    currentPath.path.put(immutablePos, (WireProperties)this.getNodeAt((BlockPos)immutablePos).data);
                    if (!secondNode.isActive) continue;
                    RoutePath finalizedPath = currentPath.cloneAndCompute(immutablePos);
                    readyPaths.add(finalizedPath);
                    continue;
                }
                currentPos.func_189536_c(facing.func_176734_d());
            }
            if (moveStack.isEmpty()) break;
            currentPos.func_189536_c((EnumFacing)moveStack.pop());
            currentPath.path.remove(currentPos);
        }
        return readyPaths;
    }

    @Override
    protected void writeNodeData(WireProperties nodeData, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("voltage", nodeData.voltage);
        tagCompound.func_74768_a("amperage", nodeData.amperage);
        tagCompound.func_74768_a("loss", nodeData.lossPerBlock);
    }

    @Override
    protected WireProperties readNodeData(NBTTagCompound tagCompound) {
        int voltage = tagCompound.func_74762_e("voltage");
        int amperage = tagCompound.func_74762_e("amperage");
        int lossPerBlock = tagCompound.func_74762_e("loss");
        return new WireProperties(voltage, amperage, lossPerBlock);
    }
}

