/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import gregtech.api.util.DummyContainer;
import gregtech.api.util.InventoryUtils;
import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSourceList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;

public class CachedRecipeData {
    private final ItemSourceList itemSourceList;
    private final IRecipe recipe;
    private final ItemStack expectedOutput;
    public final InventoryCrafting inventory = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
    private Map<ItemStackKey, Integer> requiredItems = new HashMap<ItemStackKey, Integer>();
    private boolean ingredientsMatched = false;
    private long lastTickChecked = -1L;
    private boolean recipeValidCache = false;

    public CachedRecipeData(ItemSourceList sourceList, IRecipe recipe, ItemStack expectedOutput) {
        this.itemSourceList = sourceList;
        this.recipe = recipe;
        this.expectedOutput = expectedOutput.func_77946_l();
    }

    public boolean performRecipe(EntityPlayer player) {
        this.lastTickChecked = -1L;
        if (!this.checkRecipeValid()) {
            return false;
        }
        if (!this.consumeRecipeItems(false)) {
            this.lastTickChecked = -1L;
            return false;
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        InventoryCrafting deepCopy = InventoryUtils.deepCopyInventoryCrafting(this.inventory);
        NonNullList remainingItems = this.recipe.func_179532_b(deepCopy);
        ForgeHooks.setCraftingPlayer(null);
        for (ItemStack itemStack : remainingItems) {
            itemStack = itemStack.func_77946_l();
            ItemStackKey stackKey = new ItemStackKey(itemStack);
            int remainingAmount = itemStack.func_190916_E() - this.itemSourceList.insertItem(stackKey, itemStack.func_190916_E(), false, IItemList.InsertMode.HIGHEST_PRIORITY);
            if (remainingAmount <= 0) continue;
            itemStack.func_190920_e(remainingAmount);
            player.func_191521_c(itemStack);
            if (itemStack.func_190916_E() <= 0) continue;
            player.func_146097_a(itemStack, false, false);
        }
        this.lastTickChecked = -1L;
        return true;
    }

    public boolean attemptMatchRecipe() {
        this.ingredientsMatched = false;
        this.requiredItems.clear();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.getIngredientEquivalent(i)) continue;
            return false;
        }
        this.ingredientsMatched = true;
        return true;
    }

    public boolean checkRecipeValid() {
        if (!this.ingredientsMatched) {
            return false;
        }
        long currentTick = this.itemSourceList.getWorld().func_82737_E();
        if (this.lastTickChecked == currentTick) {
            return this.recipeValidCache;
        }
        this.lastTickChecked = currentTick;
        this.recipeValidCache = this.consumeRecipeItems(true);
        return this.recipeValidCache;
    }

    private boolean consumeRecipeItems(boolean simulate) {
        for (Map.Entry<ItemStackKey, Integer> entry : this.requiredItems.entrySet()) {
            ItemStackKey itemStackKey = entry.getKey();
            if (this.itemSourceList.extractItem(itemStackKey, entry.getValue(), simulate) == entry.getValue().intValue()) continue;
            return false;
        }
        return true;
    }

    private boolean getIngredientEquivalent(int slot) {
        ItemStack currentStack = this.inventory.func_70301_a(slot);
        if (currentStack.func_190926_b()) {
            return true;
        }
        ItemStackKey currentStackKey = new ItemStackKey(currentStack);
        if (this.simulateExtractItem(currentStackKey)) {
            return true;
        }
        for (ItemStackKey itemStackKey : this.itemSourceList.getStoredItems()) {
            ItemStack itemStack = itemStackKey.getItemStack();
            this.inventory.func_70299_a(slot, itemStack);
            if (!this.recipe.func_77569_a(this.inventory, this.itemSourceList.getWorld()) || !ItemStack.func_77989_b((ItemStack)this.expectedOutput, (ItemStack)this.recipe.func_77572_b(this.inventory)) || !this.simulateExtractItem(itemStackKey)) continue;
            return true;
        }
        return false;
    }

    private boolean simulateExtractItem(ItemStackKey itemStack) {
        int amountToExtract = this.requiredItems.getOrDefault(itemStack, 0) + 1;
        int extracted = this.itemSourceList.extractItem(itemStack, amountToExtract, true);
        if (extracted == amountToExtract) {
            this.requiredItems.put(itemStack, amountToExtract);
            return true;
        }
        return false;
    }
}

