/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.render.Textures;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class SteamSolarBoiler
extends SteamBoiler {
    public SteamSolarBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.SOLAR_BOILER_OVERLAY, 55);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new SteamSolarBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    protected boolean checkCanSeeSun() {
        BlockPos blockPos = this.getPos().func_177984_a();
        if (!this.getWorld().func_175710_j(blockPos)) {
            return false;
        }
        return !this.getWorld().func_72896_J() && this.getWorld().func_72935_r();
    }

    @Override
    protected void tryConsumeNewFuel() {
        if (this.checkCanSeeSun()) {
            this.setFuelMaxBurnTime(5);
        }
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).widget(new ProgressWidget(() -> this.checkCanSeeSun() ? 1.0 : 0.0, 115, 34, 20, 20).setProgressBar(this.getGuiTexture("boiler_sun"), this.getGuiTexture("boiler_sun_active"), ProgressWidget.MoveType.HORIZONTAL)).build(this.getHolder(), entityPlayer);
    }
}

