/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.common.metatileentities.electric.multiblockpart.MetaTileEntityRotorHolder;
import gregtech.common.metatileentities.multi.electric.generator.FueledMultiblockController;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public abstract class RotorHolderMultiblockController
extends FueledMultiblockController {
    public static final MultiblockAbility<MetaTileEntityRotorHolder> ABILITY_ROTOR_HOLDER = new MultiblockAbility();

    public RotorHolderMultiblockController(ResourceLocation metaTileEntityId, FuelRecipeMap recipeMap, long maxVoltage) {
        super(metaTileEntityId, recipeMap, maxVoltage);
    }

    public MetaTileEntityRotorHolder getRotorHolder() {
        return this.getAbilities(ABILITY_ROTOR_HOLDER).get(0);
    }

    public List<MetaTileEntityRotorHolder> getRotorHolders() {
        return this.getAbilities(ABILITY_ROTOR_HOLDER);
    }

    @Override
    protected void updateFormedValid() {
        if (this.isRotorFaceFree()) {
            super.updateFormedValid();
        }
    }

    @Override
    public void invalidateStructure() {
        this.getRotorHolder().resetRotorSpeed();
        super.invalidateStructure();
    }

    public boolean isRotorFaceFree() {
        return this.isStructureFormed() && this.getAbilities(ABILITY_ROTOR_HOLDER).get(0).isFrontFaceFree();
    }

    public boolean isActive() {
        return this.isRotorFaceFree() && this.workableHandler.isActive() && this.workableHandler.isWorkingEnabled();
    }

    public abstract int getRotorSpeedIncrement();

    public abstract int getRotorSpeedDecrement();

    @Override
    @Nonnull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return super.getFrontOverlay();
    }
}

