/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.OrientedOverlayRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.InventoryUtils;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.multi.electric.MetaTileEntityElectricBlastFurnace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class MetaTileEntityMultiFurnace
extends RecipeMapMultiblockController {
    private static final MultiblockAbility<?>[] ALLOWED_ABILITIES = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.INPUT_ENERGY};
    protected int heatingCoilLevel;
    protected int heatingCoilDiscount;

    public MetaTileEntityMultiFurnace(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.FURNACE_RECIPES);
        this.recipeMapWorkable = new MultiFurnaceWorkable(this);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityMultiFurnace(this.metaTileEntityId);
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.multi_furnace.heating_coil_level", new Object[]{this.heatingCoilLevel}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.multi_furnace.heating_coil_discount", new Object[]{this.heatingCoilDiscount}));
        }
        super.addDisplayText(textList);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        BlockWireCoil.CoilType coilType = context.getOrDefault("CoilType", BlockWireCoil.CoilType.CUPRONICKEL);
        this.heatingCoilLevel = coilType.getLevel();
        this.heatingCoilDiscount = coilType.getEnergyDiscount();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.heatingCoilLevel = 0;
        this.heatingCoilDiscount = 0;
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "CCC", "XXX").aisle("XXX", "C#C", "XXX").aisle("XSX", "CCC", "XXX").setAmountAtLeast('L', 9).where('S', this.selfPredicate()).where('L', MetaTileEntityMultiFurnace.statePredicate(this.getCasingState())).where('X', MetaTileEntityMultiFurnace.statePredicate(this.getCasingState()).or(MetaTileEntityMultiFurnace.abilityPartPredicate(ALLOWED_ABILITIES))).where('C', MetaTileEntityElectricBlastFurnace.heatingCoilPredicate()).where('#', MetaTileEntityMultiFurnace.isAirPredicate()).build();
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.INVAR_HEATPROOF);
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.HEAT_PROOF_CASING;
    }

    @Override
    @Nonnull
    protected OrientedOverlayRenderer getFrontOverlay() {
        return Textures.MULTI_FURNACE_OVERLAY;
    }

    protected class MultiFurnaceWorkable
    extends MultiblockRecipeLogic {
        public MultiFurnaceWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        @Override
        protected void trySearchNewRecipe() {
            IMultipleTankHandler importFluids;
            long maxVoltage = this.getMaxVoltage();
            Recipe currentRecipe = null;
            IItemHandlerModifiable importInventory = this.getInputInventory();
            boolean dirty = this.checkRecipeInputsDirty((IItemHandler)importInventory, importFluids = this.getInputTank());
            if (dirty || this.forceRecipeRecheck) {
                this.forceRecipeRecheck = false;
                currentRecipe = this.findRecipe(maxVoltage, importInventory, importFluids);
                if (currentRecipe != null) {
                    this.previousRecipe = currentRecipe;
                }
            } else if (this.previousRecipe != null && this.previousRecipe.matches(false, importInventory, importFluids)) {
                currentRecipe = this.previousRecipe;
            }
            if (currentRecipe != null && this.setupAndConsumeRecipeInputs(currentRecipe)) {
                this.setupRecipe(currentRecipe);
            }
        }

        @Override
        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            int currentItemsEngaged = 0;
            int maxItemsLimit = 32 * MetaTileEntityMultiFurnace.this.heatingCoilLevel;
            ArrayList<CountableIngredient> recipeInputs = new ArrayList<CountableIngredient>();
            ArrayList<ItemStack> recipeOutputs = new ArrayList<ItemStack>();
            for (int index = 0; index < inputs.getSlots() && currentItemsEngaged < maxItemsLimit; ++index) {
                Recipe matchingRecipe;
                ItemStack currentInputItem = inputs.getStackInSlot(index);
                if (currentInputItem.func_190926_b() || (matchingRecipe = this.recipeMap.findRecipe(maxVoltage, Collections.singletonList(currentInputItem), Collections.emptyList(), 0)) == null) continue;
                CountableIngredient inputIngredient = matchingRecipe.getInputs().get(0);
                if (inputIngredient == null) {
                    throw new IllegalStateException(String.format("Got recipe with null ingredient %s", matchingRecipe));
                }
                int itemsLeftUntilMax = maxItemsLimit - currentItemsEngaged;
                if (itemsLeftUntilMax < inputIngredient.getCount()) continue;
                int craftsPossible = currentInputItem.func_190916_E() / inputIngredient.getCount();
                int craftsUntilMax = itemsLeftUntilMax / inputIngredient.getCount();
                int recipeMultiplier = Math.min(craftsPossible, craftsUntilMax);
                ArrayList<ItemStack> temp = new ArrayList<ItemStack>(recipeOutputs);
                this.computeOutputItemStacks(temp, (ItemStack)matchingRecipe.getOutputs().get(0), recipeMultiplier);
                boolean canFitOutputs = InventoryUtils.simulateItemStackMerge(temp, (IItemHandler)this.getOutputInventory());
                if (!canFitOutputs) break;
                temp.removeAll(recipeOutputs);
                recipeOutputs.addAll(temp);
                recipeInputs.add(new CountableIngredient(inputIngredient.getIngredient(), inputIngredient.getCount() * recipeMultiplier));
                currentItemsEngaged += inputIngredient.getCount() * recipeMultiplier;
            }
            if (recipeInputs.isEmpty()) {
                this.forceRecipeRecheck = true;
                return null;
            }
            return ((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)((RecipeBuilder)this.recipeMap.recipeBuilder()).inputsIngredients(recipeInputs)).outputs(recipeOutputs)).EUt(Math.max(1, 16 / MetaTileEntityMultiFurnace.this.heatingCoilDiscount))).duration((int)Math.max(1.0, 256.0 * ((double)currentItemsEngaged / ((double)maxItemsLimit * 1.0))))).build().getResult();
        }

        private void computeOutputItemStacks(Collection<ItemStack> recipeOutputs, ItemStack outputStack, int overclockAmount) {
            if (!outputStack.func_190926_b()) {
                int finalAmount = outputStack.func_190916_E() * overclockAmount;
                int maxCount = outputStack.func_77976_d();
                int numStacks = finalAmount / maxCount;
                int remainder = finalAmount % maxCount;
                for (int fullStacks = numStacks; fullStacks > 0; --fullStacks) {
                    ItemStack full = outputStack.func_77946_l();
                    full.func_190920_e(maxCount);
                    recipeOutputs.add(full);
                }
                if (remainder > 0) {
                    ItemStack partial = outputStack.func_77946_l();
                    partial.func_190920_e(remainder);
                    recipeOutputs.add(partial);
                }
            }
        }
    }
}

