/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;

public class MetaTileEntityPump
extends TieredMetaTileEntity {
    private static final Cuboid6 PIPE_CUBOID = new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final int BASE_PUMP_RANGE = 32;
    private static final int EXTRA_PUMP_RANGE = 8;
    private static final int PUMP_SPEED_BASE = 40;
    private Deque<BlockPos> fluidSourceBlocks = new ArrayDeque<BlockPos>();
    private Deque<BlockPos> blocksToCheck = new ArrayDeque<BlockPos>();
    private boolean initializedQueue = false;
    private int pumpHeadY;

    public MetaTileEntityPump(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityPump(this.metaTileEntityId, this.getTier());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()));
        IVertexOperation[] coloredPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)multiplier);
        for (EnumFacing renderSide : EnumFacing.field_176754_o) {
            if (renderSide == this.getFrontFacing()) {
                Textures.PIPE_OUT_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
                continue;
            }
            Textures.ADV_PUMP_OVERLAY.renderSided(renderSide, renderState, translation, coloredPipeline);
        }
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.func_150787_b(this.pumpHeadY);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.pumpHeadY = buf.func_150792_a();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 200) {
            this.pumpHeadY = buf.func_150792_a();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{new FluidTank(16000 * Math.max(1, this.getTier()))});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        return (T)(side == null || side.func_176740_k() != EnumFacing.Axis.Y ? super.getCapability(capability, side) : null);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.image(7, 16, 81, 55, GuiTextures.DISPLAY);
        TankWidget tankWidget = new TankWidget(this.exportFluids.getTankAt(0), 69, 52, 18, 18).setHideTooltip(true).setAlwaysShowFull(true);
        builder.widget(tankWidget);
        builder.label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF);
        builder.dynamicLabel(11, 30, tankWidget::getFormattedFluidAmount, 0xFFFFFF);
        builder.dynamicLabel(11, 40, tankWidget::getFluidLocalizedName, 0xFFFFFF);
        return builder.label(6, 6, this.getMetaFullName()).widget(new FluidContainerSlotWidget(this.importItems, 0, 90, 17, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new ImageWidget(91, 36, 14, 15, GuiTextures.TANK_ICON)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 54, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    private int getMaxPumpRange() {
        return 32 + 8 * this.getTier();
    }

    private boolean isStraightInPumpRange(BlockPos checkPos) {
        BlockPos pos = this.getPos();
        return checkPos.func_177958_n() == pos.func_177958_n() && checkPos.func_177952_p() == pos.func_177952_p() && pos.func_177956_o() < checkPos.func_177956_o() && pos.func_177956_o() + this.pumpHeadY >= checkPos.func_177956_o();
    }

    private void updateQueueState(int blocksToCheckAmount) {
        BlockPos selfPos = this.getPos().func_177979_c(this.pumpHeadY);
        for (int i = 0; i < blocksToCheckAmount; ++i) {
            BlockPos checkPos = null;
            int amountIterated = 0;
            do {
                if (checkPos == null) continue;
                this.blocksToCheck.push(checkPos);
                ++amountIterated;
            } while ((checkPos = this.blocksToCheck.poll()) != null && !this.getWorld().func_175667_e(checkPos) && amountIterated < this.blocksToCheck.size());
            if (checkPos == null) break;
            this.checkFluidBlockAt(selfPos, checkPos);
        }
        if (this.fluidSourceBlocks.isEmpty()) {
            if (this.getOffsetTimer() % 20L == 0L) {
                IBlockState downBlock;
                BlockPos downPos = selfPos.func_177979_c(1);
                if (downPos != null && downPos.func_177956_o() >= 0 && ((downBlock = this.getWorld().func_180495_p(downPos)).func_177230_c() instanceof BlockLiquid || downBlock.func_177230_c() instanceof IFluidBlock || !downBlock.func_185896_q())) {
                    ++this.pumpHeadY;
                }
                this.writeCustomData(200, b -> b.func_150787_b(this.pumpHeadY));
                this.markDirty();
                this.initializedQueue = false;
            }
            if (!this.initializedQueue || this.getOffsetTimer() % 6000L == 0L || this.getTimer() == 0L) {
                this.initializedQueue = true;
                this.blocksToCheck.add(selfPos);
            }
        }
    }

    private void checkFluidBlockAt(BlockPos pumpHeadPos, BlockPos checkPos) {
        IBlockState blockHere = this.getWorld().func_180495_p(checkPos);
        boolean shouldCheckNeighbours = this.isStraightInPumpRange(checkPos);
        if (blockHere.func_177230_c() instanceof BlockLiquid || blockHere.func_177230_c() instanceof IFluidBlock) {
            IFluidHandler fluidHandler = FluidUtil.getFluidHandler((World)this.getWorld(), (BlockPos)checkPos, null);
            FluidStack drainStack = fluidHandler.drain(Integer.MAX_VALUE, false);
            if (drainStack != null && drainStack.amount > 0) {
                this.fluidSourceBlocks.add(checkPos);
            }
            shouldCheckNeighbours = true;
        }
        if (shouldCheckNeighbours) {
            int maxPumpRange = this.getMaxPumpRange();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos offsetPos = checkPos.func_177972_a(facing);
                if (offsetPos.func_177951_i((Vec3i)pumpHeadPos) > (double)(maxPumpRange * maxPumpRange) || this.fluidSourceBlocks.contains(offsetPos) || this.blocksToCheck.contains(offsetPos)) continue;
                this.blocksToCheck.add(offsetPos);
            }
        }
    }

    private void tryPumpFirstBlock() {
        IFluidHandler fluidHandler;
        FluidStack drainStack;
        BlockPos fluidBlockPos = this.fluidSourceBlocks.poll();
        if (fluidBlockPos == null) {
            return;
        }
        IBlockState blockHere = this.getWorld().func_180495_p(fluidBlockPos);
        if ((blockHere.func_177230_c() instanceof BlockLiquid || blockHere.func_177230_c() instanceof IFluidBlock) && (drainStack = (fluidHandler = FluidUtil.getFluidHandler((World)this.getWorld(), (BlockPos)fluidBlockPos, null)).drain(Integer.MAX_VALUE, false)) != null && this.exportFluids.fill(drainStack, false) == drainStack.amount) {
            this.exportFluids.fill(drainStack, true);
            fluidHandler.drain(drainStack.amount, true);
            this.fluidSourceBlocks.remove(fluidBlockPos);
            this.energyContainer.changeEnergy(-GTValues.V[this.getTier()]);
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (this.energyContainer.getEnergyStored() < GTValues.V[this.getTier()] * 4L) {
            return;
        }
        this.pushFluidsIntoNearbyHandlers(this.getFrontFacing());
        this.fillContainerFromInternalTank(this.importItems, this.exportItems, 0, 0);
        this.updateQueueState(this.getTier());
        if (this.getOffsetTimer() % (long)this.getPumpingCycleLength() == 0L && !this.fluidSourceBlocks.isEmpty() && this.energyContainer.getEnergyStored() >= GTValues.V[this.getTier()]) {
            this.tryPumpFirstBlock();
        }
    }

    private int getPumpingCycleLength() {
        return 40 / Math.max(1, this.getTier());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("PumpHeadDepth", this.pumpHeadY);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pumpHeadY = data.func_74762_e("PumpHeadDepth");
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        int maxPumpRange = this.getMaxPumpRange();
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.pump.tooltip_range", (Object[])new Object[]{maxPumpRange, maxPumpRange}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.pump.tooltip_speed", (Object[])new Object[]{this.getPumpingCycleLength()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VN[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.exportFluids.getTankAt(0).getCapacity()}));
    }
}

