/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.render.Textures;
import gregtech.api.unification.OreDictUnifier;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MetaTileEntityFisher
extends TieredMetaTileEntity {
    private static final int WATER_CHECK_SIZE = 25;
    private final int inventorySize;
    private final long fishingTicks;
    private final long energyAmountPerFish;

    public MetaTileEntityFisher(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.fishingTicks = 1000 - tier * 200;
        this.energyAmountPerFish = GTValues.V[tier];
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new MetaTileEntityFisher(this.metaTileEntityId, this.getTier());
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 18 + 18 * rowSize + 94).label(10, 5, this.getMetaFullName()).widget(new SlotWidget((IItemHandler)this.importItems, 0, 18, 18, true, true).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.STRING_SLOT_OVERLAY));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                builder.widget(new SlotWidget((IItemHandler)this.exportItems, index, 89 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 18 + 18 * rowSize + 12);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public void update() {
        super.update();
        ItemStack baitStack = this.importItems.getStackInSlot(0);
        if (!this.getWorld().field_72995_K && this.energyContainer.getEnergyStored() >= this.energyAmountPerFish && this.getOffsetTimer() % this.fishingTicks == 0L && !baitStack.func_190926_b()) {
            WorldServer world = (WorldServer)this.getWorld();
            int waterCount = 0;
            int edgeSize = (int)Math.sqrt(25.0);
            for (int x = 0; x < edgeSize; ++x) {
                for (int z = 0; z < edgeSize; ++z) {
                    BlockPos waterCheckPos = this.getPos().func_177977_b().func_177982_a(x - edgeSize / 2, 0, z - edgeSize / 2);
                    if (!(world.func_180495_p(waterCheckPos).func_177230_c() instanceof BlockLiquid) || world.func_180495_p(waterCheckPos).func_185904_a() != Material.field_151586_h) continue;
                    ++waterCount;
                }
            }
            if (waterCount == 25) {
                LootTable table = world.func_184146_ak().func_186521_a(LootTableList.field_186387_al);
                NonNullList itemStacks = NonNullList.func_191196_a();
                itemStacks.addAll((Collection)table.func_186462_a(world.field_73012_v, new LootContext.Builder(world).func_186471_a()));
                if (MetaTileEntityFisher.addItemsToItemHandler((IItemHandler)this.exportItems, true, (List<ItemStack>)itemStacks)) {
                    MetaTileEntityFisher.addItemsToItemHandler((IItemHandler)this.exportItems, false, (List<ItemStack>)itemStacks);
                    this.energyContainer.removeEnergy(this.energyAmountPerFish);
                    baitStack.func_190918_g(1);
                }
            }
        }
        if (!this.getWorld().field_72995_K && this.getOffsetTimer() % 5L == 0L) {
            this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
        }
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(1){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (OreDictUnifier.getOreDictionaryNames(stack).contains("string")) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(this.inventorySize);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        Textures.PIPE_OUT_OVERLAY.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
        Textures.PIPE_IN_OVERLAY.renderSided(EnumFacing.DOWN, renderState, translation, pipeline);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VN[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fisher.speed", (Object[])new Object[]{this.fishingTicks}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fisher.requirement", (Object[])new Object[]{(int)Math.sqrt(25.0)}));
    }
}

