/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.potions;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import gregtech.api.util.GTUtility;
import gregtech.common.MetaFluids;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.potions.BlockPotionFluid;
import gregtech.common.items.potions.GlassBottleFluidHandler;
import gregtech.common.items.potions.PotionItemFluidHandler;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PotionFluids {
    private static final BiMap<ResourceLocation, Fluid> potionFluidMap = HashBiMap.create();
    public static final int POTION_ITEM_FLUID_AMOUNT = 100;

    public static Fluid getFluidForPotion(PotionType potion) {
        return (Fluid)potionFluidMap.get((Object)potion.getRegistryName());
    }

    public static PotionType getPotionForFluid(Fluid potionFluid) {
        ResourceLocation registryName = (ResourceLocation)potionFluidMap.inverse().get((Object)potionFluid);
        return registryName == null ? null : (PotionType)ForgeRegistries.POTION_TYPES.getValue(registryName);
    }

    public static void initPotionFluids() {
        MinecraftForge.EVENT_BUS.register((Object)new PotionFluids());
        for (ResourceLocation registryName : ForgeRegistries.POTION_TYPES.getKeys()) {
            Fluid potionFluid;
            if (registryName.func_110624_b().equals("minecraft") && registryName.func_110623_a().equals("empty")) continue;
            final PotionType potion = (PotionType)ForgeRegistries.POTION_TYPES.getValue(registryName);
            Preconditions.checkNotNull((Object)potion);
            if (potion != PotionTypes.field_185230_b) {
                String fluidName = String.format("potion.%s.%s", registryName.func_110624_b(), registryName.func_110623_a());
                potionFluid = new Fluid(fluidName, MetaFluids.AUTO_GENERATED_FLUID_TEXTURE, MetaFluids.AUTO_GENERATED_FLUID_TEXTURE){

                    public String getUnlocalizedName() {
                        return potion.func_185174_b("potion.effect.");
                    }
                };
                potionFluid.setColor(GTUtility.convertRGBtoOpaqueRGBA_MC(PotionUtils.func_185183_a((PotionType)potion)));
                FluidRegistry.registerFluid((Fluid)potionFluid);
                FluidRegistry.addBucketForFluid((Fluid)potionFluid);
                BlockPotionFluid fluidBlock = new BlockPotionFluid(potionFluid, potion);
                fluidBlock.setRegistryName("fluid." + fluidName);
                MetaBlocks.FLUID_BLOCKS.add((BlockFluidBase)fluidBlock);
            } else {
                potionFluid = FluidRegistry.WATER;
            }
            potionFluidMap.put((Object)potion.getRegistryName(), (Object)potionFluid);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCapabilityAttach(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack itemStack = (ItemStack)event.getObject();
        if (itemStack.func_77973_b() instanceof ItemPotion) {
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", "fluid_container");
            PotionItemFluidHandler fluidHandler = new PotionItemFluidHandler(itemStack);
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        } else if (itemStack.func_77973_b() instanceof ItemGlassBottle) {
            ResourceLocation resourceLocation = new ResourceLocation("gregtech", "fluid_container");
            GlassBottleFluidHandler fluidHandler = new GlassBottleFluidHandler(itemStack, event.getCapabilities().values());
            event.addCapability(resourceLocation, (ICapabilityProvider)fluidHandler);
        }
    }
}

