/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.items.metaitem.stats.IItemUseManager;
import gregtech.api.items.toolitem.IScannableBlock;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;

public class ScannerBehavior
implements IItemBehaviour,
IItemUseManager {
    private final int costPerUseTick;

    public ScannerBehavior(int costPerUseTick) {
        this.costPerUseTick = costPerUseTick;
    }

    @Override
    public boolean canStartUsing(ItemStack stack, EntityPlayer player) {
        return this.checkCanUseScanner(stack, player, true).getLeft() == null;
    }

    private Pair<BlockPos, IBlockState> getHitBlock(EntityPlayer entityPlayer) {
        BlockPos blockPos;
        IBlockState blockState;
        RayTraceResult result = RayTracer.retrace((EntityPlayer)entityPlayer);
        if (result.field_72313_a == RayTraceResult.Type.BLOCK && (blockState = entityPlayer.field_70170_p.func_180495_p(blockPos = result.func_178782_a())).func_177230_c() instanceof IScannableBlock) {
            return Pair.of((Object)blockPos, (Object)blockState);
        }
        return null;
    }

    private boolean dischargeItem(ItemStack itemStack, long amount, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null) {
            return false;
        }
        long dischargeAmount = amount * (long)this.costPerUseTick;
        return electricItem.discharge(dischargeAmount, Integer.MAX_VALUE, true, false, simulate) >= dischargeAmount;
    }

    private Pair<String, Integer> checkCanUseScanner(ItemStack itemStack, EntityPlayer player, boolean simulate) {
        Pair<BlockPos, IBlockState> hitBlock = this.getHitBlock(player);
        if (hitBlock == null) {
            return Pair.of((Object)"behavior.scanner.analyzing_failed", (Object)0);
        }
        IBlockState state = (IBlockState)hitBlock.getRight();
        long amount = ((IScannableBlock)state.func_177230_c()).getScanDuration((IBlockAccess)player.field_70170_p, (BlockPos)hitBlock.getLeft(), state, player);
        if (!this.dischargeItem(itemStack, amount, simulate)) {
            return Pair.of((Object)"metaitem.scanner.not_enough_energy", (Object)0);
        }
        int maxHitUse = ((IScannableBlock)state.func_177230_c()).getScanDuration((IBlockAccess)player.field_70170_p, (BlockPos)hitBlock.getLeft(), state, player);
        return Pair.of(null, (Object)maxHitUse);
    }

    @Override
    public void onItemUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (!player.field_70170_p.field_72995_K) {
            Pair<String, Integer> pair = this.checkCanUseScanner(stack, player, true);
            String failureReason = (String)pair.getLeft();
            if (failureReason == null) {
                TextComponentTranslation component = new TextComponentTranslation("behavior.scanner.analyzing", new Object[0]);
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                player.func_146105_b((ITextComponent)component, true);
                int maxUseCount = (Integer)pair.getRight();
                if (this.getMaxItemUseDuration(stack) - count >= maxUseCount) {
                    player.field_184628_bn = 0;
                }
            } else {
                TextComponentTranslation component = new TextComponentTranslation(failureReason, new Object[0]);
                component.func_150256_b().func_150238_a(TextFormatting.RED);
                player.func_146105_b((ITextComponent)component, true);
                player.func_184597_cx();
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            }
        }
    }

    @Override
    public ItemStack onItemUseFinish(ItemStack stack, EntityPlayer player) {
        Pair<BlockPos, IBlockState> hitBlock;
        if (!player.field_70170_p.field_72995_K && (hitBlock = this.getHitBlock(player)) != null && this.checkCanUseScanner(stack, player, false).getLeft() == null) {
            TextComponentTranslation component = new TextComponentTranslation("behavior.scanner.analyzing_complete", new Object[0]);
            component.func_150256_b().func_150238_a(TextFormatting.GOLD);
            player.func_146105_b((ITextComponent)component, true);
            IScannableBlock magnifiableBlock = (IScannableBlock)((IBlockState)hitBlock.getRight()).func_177230_c();
            List<ITextComponent> text = magnifiableBlock.getMagnifyResults((IBlockAccess)player.field_70170_p, (BlockPos)hitBlock.getLeft(), (IBlockState)hitBlock.getRight(), player);
            text.forEach(arg_0 -> ((EntityPlayer)player).func_145747_a(arg_0));
        }
        return stack;
    }

    @Override
    public EnumAction getUseAction(ItemStack stack) {
        return EnumAction.NONE;
    }

    @Override
    public int getMaxItemUseDuration(ItemStack stack) {
        return 200000;
    }
}

