/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource;

import gregtech.api.util.GTUtility;
import gregtech.api.util.ItemStackKey;
import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSource;
import gregtech.common.inventory.itemsource.NetworkItemInfo;
import gregtech.common.pipelike.inventory.network.UpdateResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public class ItemSourceList
implements IItemList,
ITickable {
    protected final World world;
    protected final List<ItemSource> handlerInfoList = new CopyOnWriteArrayList<ItemSource>();
    protected final Map<ItemStackKey, NetworkItemInfo> itemInfoMap = new LinkedHashMap<ItemStackKey, NetworkItemInfo>();
    private final Comparator<ItemSource> comparator = Comparator.comparing(ItemSource::getPriority);
    private final Set<ItemStackKey> storedItemsView = Collections.unmodifiableSet(this.itemInfoMap.keySet());
    protected Runnable itemListChangeCallback = null;
    private boolean callbackWasCalled = false;
    private boolean disableCallback = false;

    public ItemSourceList(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public void addItemListChangeCallback(Runnable changeCallback) {
        this.itemListChangeCallback = GTUtility.combine(this.itemListChangeCallback, changeCallback);
    }

    @Override
    public Set<ItemStackKey> getStoredItems() {
        return this.storedItemsView;
    }

    @Override
    @Nullable
    public IItemInfo getItemInfo(ItemStackKey stackKey) {
        return this.itemInfoMap.get(stackKey);
    }

    public void disableCallback() {
        this.disableCallback = true;
        this.callbackWasCalled = false;
    }

    public void enableCallback() {
        this.disableCallback = false;
        if (this.callbackWasCalled && this.itemListChangeCallback != null) {
            this.callbackWasCalled = false;
            this.itemListChangeCallback.run();
        }
    }

    public void func_73660_a() {
        this.handlerInfoList.forEach(ItemSource::update);
    }

    @Override
    public int insertItem(ItemStackKey itemStack, int amount, boolean simulate, IItemList.InsertMode insertMode) {
        int amountToInsert = amount;
        if (insertMode == IItemList.InsertMode.HIGHEST_PRIORITY) {
            ItemSource itemSource;
            int inserted;
            Iterator<ItemSource> iterator = this.handlerInfoList.iterator();
            while (iterator.hasNext() && (amountToInsert -= (inserted = (itemSource = iterator.next()).insertItem(itemStack, amountToInsert, simulate))) != 0) {
            }
        } else {
            ItemSource itemSource;
            int inserted;
            for (int i = this.handlerInfoList.size() - 1; i >= 0 && (amountToInsert -= (inserted = (itemSource = this.handlerInfoList.get(i)).insertItem(itemStack, amountToInsert, simulate))) != 0; --i) {
            }
        }
        return amount - amountToInsert;
    }

    @Override
    public int extractItem(ItemStackKey itemStack, int amount, boolean simulate) {
        NetworkItemInfo itemInfo = (NetworkItemInfo)this.getItemInfo(itemStack);
        if (itemInfo == null) {
            return 0;
        }
        return itemInfo.extractItem(amount, simulate);
    }

    public void notifyPriorityUpdated() {
        this.handlerInfoList.sort(this.comparator);
    }

    public boolean addItemHandler(ItemSource handlerInfo) {
        if (!this.handlerInfoList.contains(handlerInfo)) {
            handlerInfo.setStoredItemsChangeCallback((storedItems, removedItems) -> this.updateStoredItems(handlerInfo, storedItems, removedItems));
            if (handlerInfo.update() == UpdateResult.INVALID) {
                return false;
            }
            handlerInfo.setInvalidationCallback(() -> this.removeItemHandler(handlerInfo));
            this.handlerInfoList.add(handlerInfo);
            this.addItemHandlerPost(handlerInfo);
            this.notifyPriorityUpdated();
            return true;
        }
        return false;
    }

    public void removeItemHandler(ItemSource handlerInfo) {
        if (this.handlerInfoList.remove(handlerInfo)) {
            handlerInfo.setStoredItemsChangeCallback(null);
            handlerInfo.setInvalidationCallback(null);
            for (ItemStackKey itemStackKey : this.itemInfoMap.keySet()) {
                NetworkItemInfo itemInfo = this.itemInfoMap.get(itemStackKey);
                itemInfo.removeInventory(handlerInfo);
            }
            this.removeItemHandlerPost(handlerInfo);
        }
    }

    protected void addItemHandlerPost(ItemSource handlerInfo) {
    }

    protected void removeItemHandlerPost(ItemSource handlerInfo) {
    }

    void updateStoredItems(ItemSource handlerInfo, Map<ItemStackKey, Integer> itemAmount, Set<ItemStackKey> removedItems) {
        boolean updatedItemAmount = false;
        for (ItemStackKey itemStackKey : itemAmount.keySet()) {
            int extractedAmount = handlerInfo.extractItem(itemStackKey, 1, true);
            if (extractedAmount <= 0) continue;
            NetworkItemInfo itemInfo = this.itemInfoMap.get(itemStackKey);
            if (itemInfo == null) {
                itemInfo = new NetworkItemInfo(itemStackKey);
                this.itemInfoMap.put(itemStackKey, itemInfo);
            }
            updatedItemAmount |= itemInfo.addInventory(handlerInfo, itemAmount.get(itemStackKey));
        }
        for (ItemStackKey removedItem : removedItems) {
            NetworkItemInfo itemInfo = this.itemInfoMap.get(removedItem);
            if (itemInfo == null) continue;
            updatedItemAmount |= itemInfo.removeInventory(handlerInfo);
            if (itemInfo.getTotalItemAmount() != 0) continue;
            this.itemInfoMap.remove(removedItem);
        }
        if (updatedItemAmount && this.itemListChangeCallback != null) {
            if (!this.disableCallback) {
                this.itemListChangeCallback.run();
            } else {
                this.callbackWasCalled = true;
            }
        }
    }
}

