/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.Position;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class MemorizedRecipeWidget
extends SlotWidget {
    private final CraftingRecipeMemory recipeMemory;
    private final int recipeIndex;
    private boolean recipeLocked = false;
    private IItemHandlerModifiable craftingGrid;

    public MemorizedRecipeWidget(CraftingRecipeMemory recipeMemory, int index, IItemHandlerModifiable craftingGrid, int xPosition, int yPosition) {
        super((IItemHandler)new ItemStackHandler(1), 0, xPosition, yPosition, false, false);
        this.recipeMemory = recipeMemory;
        this.recipeIndex = index;
        this.craftingGrid = craftingGrid;
    }

    @Override
    public void detectAndSendChanges() {
        boolean recipeLocked;
        ItemStack resultStack;
        super.detectAndSendChanges();
        CraftingRecipeMemory.MemorizedRecipe recipe = this.recipeMemory.getRecipeAtIndex(this.recipeIndex);
        ItemStack itemStack = resultStack = recipe == null ? ItemStack.field_190927_a : recipe.getRecipeResult();
        if (!ItemStack.func_77989_b((ItemStack)resultStack, (ItemStack)this.slotReference.func_75211_c())) {
            this.slotReference.func_75215_d(resultStack);
            this.uiAccess.sendSlotUpdate(this);
        }
        boolean bl = recipeLocked = recipe != null && recipe.isRecipeLocked();
        if (this.recipeLocked != recipeLocked) {
            this.recipeLocked = recipeLocked;
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(recipeLocked));
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        if (this.recipeLocked) {
            Position pos = this.getPosition();
            GlStateManager.func_179097_i();
            GuiTextures.LOCK.draw(pos.x, pos.y + 10, 8, 8);
            GlStateManager.func_179126_j();
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.recipeLocked = buffer.readBoolean();
        }
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, EntityPlayer player) {
        CraftingRecipeMemory.MemorizedRecipe recipe;
        if (!player.field_70170_p.field_72995_K && (recipe = this.recipeMemory.getRecipeAtIndex(this.recipeIndex)) != null && !recipe.getRecipeResult().func_190926_b()) {
            if (clickTypeIn == ClickType.PICKUP) {
                this.recipeMemory.loadRecipe(this.recipeIndex, this.craftingGrid);
                player.field_71070_bA.func_75142_b();
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                recipe.setRecipeLocked(!recipe.isRecipeLocked());
            }
        }
        return ItemStack.field_190927_a;
    }
}

