/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.util;

import gregtech.common.datafix.util.RemappedBlock;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.chunk.NibbleArray;

public class DataFixHelper {
    public static void rewriteCompoundTags(NBTTagCompound tag, CompoundRewriter rewriter) {
        for (String key : tag.func_150296_c()) {
            NBTBase childTag = tag.func_74781_a(key);
            switch (childTag.func_74732_a()) {
                case 9: {
                    DataFixHelper.rewriteCompoundTags((NBTTagList)childTag, rewriter);
                    break;
                }
                case 10: {
                    NBTTagCompound childTagCompound = (NBTTagCompound)childTag;
                    DataFixHelper.rewriteCompoundTags(childTagCompound, rewriter);
                    childTagCompound = rewriter.rewrite(childTagCompound);
                    if (childTagCompound == null) break;
                    tag.func_74782_a(key, (NBTBase)childTagCompound);
                }
            }
        }
    }

    public static void rewriteCompoundTags(NBTTagList tag, CompoundRewriter rewriter) {
        block4: for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTBase childTag = tag.func_179238_g(i);
            switch (childTag.func_74732_a()) {
                case 9: {
                    DataFixHelper.rewriteCompoundTags((NBTTagList)childTag, rewriter);
                    continue block4;
                }
                case 10: {
                    NBTTagCompound childTagCompound = (NBTTagCompound)childTag;
                    DataFixHelper.rewriteCompoundTags(childTagCompound, rewriter);
                    childTagCompound = rewriter.rewrite(childTagCompound);
                    if (childTagCompound == null) continue block4;
                    tag.func_150304_a(i, (NBTBase)childTagCompound);
                }
            }
        }
    }

    public static void rewriteBlocks(NBTTagCompound chunkSectionTag, BlockRewriter rewriter) {
        byte[] blockIds = chunkSectionTag.func_74770_j("Blocks");
        NibbleArray blockData = new NibbleArray(chunkSectionTag.func_74770_j("Data"));
        NibbleArray extendedIds = chunkSectionTag.func_150297_b("Add", 7) ? new NibbleArray(chunkSectionTag.func_74770_j("Add")) : null;
        for (int i = 0; i < 4096; ++i) {
            int z;
            int y;
            int x;
            int id = extendedIds == null ? blockIds[i] & 0xFF : blockIds[i] & 0xFF | extendedIds.func_76582_a(x, y, z) << 8;
            RemappedBlock remapped = rewriter.rewrite(id, (short)blockData.func_76582_a(x = i & 0xF, y = i >> 8 & 0xF, z = i >> 4 & 0xF));
            if (remapped == null) continue;
            blockIds[i] = (byte)(remapped.id & 0xFF);
            int idExt = remapped.id >> 8 & 0xF;
            if (idExt != 0) {
                if (extendedIds == null) {
                    extendedIds = new NibbleArray();
                }
                extendedIds.func_76581_a(x, y, z, idExt);
            }
            blockData.func_76581_a(x, y, z, remapped.data & 0xF);
        }
        if (extendedIds != null) {
            chunkSectionTag.func_74773_a("Add", extendedIds.func_177481_a());
        }
    }

    @FunctionalInterface
    public static interface BlockRewriter {
        @Nullable
        public RemappedBlock rewrite(int var1, short var2);
    }

    @FunctionalInterface
    public static interface CompoundRewriter {
        @Nullable
        public NBTTagCompound rewrite(NBTTagCompound var1);
    }
}

