/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixHelper;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdFixer;
import gregtech.common.datafix.fixes.metablockid.MetaBlockIdRemapCache;
import gregtech.common.datafix.util.RemappedBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PostGraniteMetaBlockIdFixer
implements MetaBlockIdFixer {
    protected static final String KEY_REMAP_CACHE_COMPRESSED = "RemapCacheCompressed";
    protected static final String KEY_REMAP_CACHE_SURF_ROCK = "RemapCacheSurfaceRock";
    @Nullable
    private static List<int[]> tableOldAllocCompressed = null;
    @Nullable
    private static List<int[]> tableOldAllocSurfRock = null;
    private final MetaBlockIdRemapCache remapCacheCompressed;
    private final MetaBlockIdRemapCache remapCacheSurfRock;

    protected static List<int[]> getTableOldAllocCompressed() {
        if (tableOldAllocCompressed == null) {
            tableOldAllocCompressed = MetaBlockIdFixHelper.collectOldMetaBlockAlloc(mat -> mat instanceof DustMaterial && !OrePrefix.block.isIgnored((Material)mat));
        }
        return tableOldAllocCompressed;
    }

    protected static List<int[]> getTableOldAllocSurfRock() {
        if (tableOldAllocSurfRock == null) {
            tableOldAllocSurfRock = MetaBlockIdFixHelper.collectOldMetaBlockAlloc(mat -> mat instanceof IngotMaterial && mat.hasFlag(DustMaterial.MatFlags.GENERATE_ORE));
        }
        return tableOldAllocSurfRock;
    }

    public PostGraniteMetaBlockIdFixer(MetaBlockIdRemapCache remapCacheCompressed, MetaBlockIdRemapCache remapCacheSurfRock) {
        this.remapCacheCompressed = remapCacheCompressed;
        this.remapCacheSurfRock = remapCacheSurfRock;
    }

    public static PostGraniteMetaBlockIdFixer generate(NBTTagCompound fmlTag) {
        NBTTagList blockRegistryTag = MetaBlockIdFixHelper.getBlockRegistryTag(fmlTag);
        if (blockRegistryTag == null) {
            throw new IllegalStateException("Block registry is not serialized in level data!");
        }
        MetaBlockIdRemapCache[] remapCaches = MetaBlockIdRemapCache.generate(blockRegistryTag, new MetaBlockIdRemapCache.Spec("meta_block_compressed_", MetaBlockIdFixHelper::getCompressedIndexFromResLoc, false), new MetaBlockIdRemapCache.Spec("meta_block_surface_rock_", MetaBlockIdFixHelper::getSurfRockIndexFromResLoc, false));
        return new PostGraniteMetaBlockIdFixer(remapCaches[0], remapCaches[1]);
    }

    @Override
    public int getFallbackDataVersion() {
        return 0;
    }

    public MetaBlockIdRemapCache getRemapCacheCompressed() {
        return this.remapCacheCompressed;
    }

    public MetaBlockIdRemapCache getRemapCacheSurfRock() {
        return this.remapCacheSurfRock;
    }

    public RemappedBlock remapCompressedPostGraniteToNew(int index, int data) {
        int matId = PostGraniteMetaBlockIdFixer.getTableOldAllocCompressed().get(index)[data];
        return new RemappedBlock(matId / 16, (short)(matId % 16));
    }

    public RemappedBlock remapSurfRockToNew(int index, int data) {
        int matId = PostGraniteMetaBlockIdFixer.getTableOldAllocSurfRock().get(index)[data];
        return new RemappedBlock(matId / 16, (short)(matId % 16));
    }

    @Override
    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("FallbackVersion", 0);
        tag.func_74782_a(KEY_REMAP_CACHE_COMPRESSED, (NBTBase)this.remapCacheCompressed.serialize());
        tag.func_74782_a(KEY_REMAP_CACHE_SURF_ROCK, (NBTBase)this.remapCacheSurfRock.serialize());
        return tag;
    }

    public static PostGraniteMetaBlockIdFixer deserialize(NBTTagCompound tag) {
        return new PostGraniteMetaBlockIdFixer(MetaBlockIdRemapCache.deserialize("meta_block_compressed_", tag.func_74775_l(KEY_REMAP_CACHE_COMPRESSED)), MetaBlockIdRemapCache.deserialize("meta_block_surface_rock_", tag.func_74775_l(KEY_REMAP_CACHE_SURF_ROCK)));
    }
}

