/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MetaBlockIdRemapCache {
    private static final String KEY_ID_MAPPING = "IdMapping";
    private static final int SER_MASK_ID = -64;
    private static final int SER_MASK_INDEX = 63;
    private final String newNamePrefix;
    private final TIntIntMap idToIndex;
    private final TIntIntMap indexToId;
    private final int[] newIdCache = new int[63];

    private MetaBlockIdRemapCache(String newNamePrefix, TIntIntMap idToIndex, TIntIntMap indexToId) {
        this.newNamePrefix = newNamePrefix;
        this.idToIndex = idToIndex;
        this.indexToId = indexToId;
        Arrays.fill(this.newIdCache, -1);
    }

    public int getOldIndex(int id) {
        return this.idToIndex.get(id);
    }

    public int getOldId(int index) {
        return this.indexToId.get(index);
    }

    public int getNewId(int index) {
        int id = this.newIdCache[index];
        if (id != -1) {
            return id;
        }
        this.newIdCache[index] = Block.func_149682_b((Block)((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation("gregtech", this.newNamePrefix + index)))));
        return this.newIdCache[index];
    }

    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        int[] idMapSer = new int[this.idToIndex.size()];
        int entryNdx = 0;
        TIntIntIterator iter = this.idToIndex.iterator();
        while (iter.hasNext()) {
            iter.advance();
            idMapSer[entryNdx++] = iter.key() << 6 & 0xFFFFFFC0 | iter.value() & 0x3F;
        }
        tag.func_74783_a(KEY_ID_MAPPING, idMapSer);
        return tag;
    }

    public static MetaBlockIdRemapCache deserialize(String newNamePrefix, NBTTagCompound tag) {
        int[] idMapSer = tag.func_74759_k(KEY_ID_MAPPING);
        TIntIntHashMap idToIndex = new TIntIntHashMap(idMapSer.length, 1.1f, -1, -1);
        TIntIntHashMap indexToId = new TIntIntHashMap(idMapSer.length, 1.1f, -1, -1);
        for (int entrySer : idMapSer) {
            int id = (entrySer & 0xFFFFFFC0) >>> 6;
            int index = entrySer & 0x3F;
            idToIndex.put(id, index);
            indexToId.put(index, id);
        }
        return new MetaBlockIdRemapCache(newNamePrefix, (TIntIntMap)idToIndex, (TIntIntMap)indexToId);
    }

    public static MetaBlockIdRemapCache[] generate(NBTTagList regEntryListTag, Spec ... metaBlockSpecs) {
        MappingCollection[] mappings = new MappingCollection[metaBlockSpecs.length];
        for (int specNdx = 0; specNdx < metaBlockSpecs.length; ++specNdx) {
            mappings[specNdx] = new MappingCollection();
        }
        int maxBlockId = -1;
        block1: for (int i = 0; i < regEntryListTag.func_74745_c(); ++i) {
            NBTTagCompound regEntryTag = regEntryListTag.func_150305_b(i);
            int id = regEntryTag.func_74762_e("V");
            if (id > maxBlockId) {
                maxBlockId = id;
            }
            for (int specNdx = 0; specNdx < metaBlockSpecs.length; ++specNdx) {
                int index = metaBlockSpecs[specNdx].indexParser.applyAsInt(regEntryTag.func_74779_i("K"));
                if (index == -1) continue;
                MappingCollection mapping = mappings[specNdx];
                mapping.idToIndex.put(id, index);
                mapping.indexToId.put(index, id);
                if (index <= mapping.maxIndex) continue block1;
                mapping.maxIndex = index;
                continue block1;
            }
        }
        for (int specNdx = 0; specNdx < metaBlockSpecs.length; ++specNdx) {
            if (!metaBlockSpecs[specNdx].addAdditionalIndex) continue;
            MappingCollection mapping = mappings[specNdx];
            mapping.idToIndex.put(++maxBlockId, mapping.maxIndex + 1);
            mapping.indexToId.put(mapping.maxIndex + 1, maxBlockId);
        }
        MetaBlockIdRemapCache[] result = new MetaBlockIdRemapCache[mappings.length];
        for (int specNdx = 0; specNdx < metaBlockSpecs.length; ++specNdx) {
            result[specNdx] = mappings[specNdx].bake(metaBlockSpecs[specNdx].newNamePrefix);
        }
        return result;
    }

    private static class MappingCollection {
        final TIntIntMap idToIndex = new TIntIntHashMap(16, 0.8f, -1, -1);
        final TIntIntMap indexToId = new TIntIntHashMap(16, 0.8f, -1, -1);
        int maxIndex = -1;

        private MappingCollection() {
        }

        MetaBlockIdRemapCache bake(String newNamePrefix) {
            return new MetaBlockIdRemapCache(newNamePrefix, this.idToIndex, this.indexToId);
        }
    }

    public static class Spec {
        final String newNamePrefix;
        final ToIntFunction<String> indexParser;
        final boolean addAdditionalIndex;

        public Spec(String newNamePrefix, ToIntFunction<String> indexParser, boolean addAdditionalIndex) {
            this.newNamePrefix = newNamePrefix;
            this.indexParser = indexParser;
            this.addAdditionalIndex = addAdditionalIndex;
        }
    }
}

