/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.datafix.fixes.metablockid;

import com.google.common.collect.ImmutableList;
import gregtech.api.unification.material.type.Material;
import gregtech.api.util.Version;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MetaBlockIdFixHelper {
    public static final Version V1_10_5 = new Version(1, 10, 5);
    public static final Version V1_15_0 = new Version(1, 15, 0);
    public static final String KEY_FALLBACK_VERSION = "FallbackVersion";
    public static final String COMP_NAME_PREF = "compressed_";
    public static final String COMP_RESLOC_PREF = "gregtech:compressed_";
    public static final int COMP_RESLOC_PREF_LEN = "gregtech:compressed_".length();
    public static final String COMP_NAME_PREF_NEW = "meta_block_compressed_";
    public static final String COMP_RESLOC_PREF_NEW = "gregtech:meta_block_compressed_";
    public static final String SURF_ROCK_NAME_PREF = "surface_rock_";
    public static final String SURF_ROCK_RESLOC_PREF = "gregtech:surface_rock_";
    public static final int SURF_ROCK_RESLOC_PREF_LEN = "gregtech:surface_rock_".length();
    public static final String SURF_ROCK_NAME_PREF_NEW = "meta_block_surface_rock_";
    public static final String SURF_ROCK_RESLOC_PREF_NEW = "gregtech:meta_block_surface_rock_";

    private MetaBlockIdFixHelper() {
    }

    public static int getCompressedIndexFromResLoc(String resLoc) {
        if (resLoc.startsWith(COMP_RESLOC_PREF)) {
            try {
                return Integer.parseInt(resLoc.substring(COMP_RESLOC_PREF_LEN));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int getSurfRockIndexFromResLoc(String resLoc) {
        if (resLoc.startsWith(SURF_ROCK_RESLOC_PREF)) {
            try {
                return Integer.parseInt(resLoc.substring(SURF_ROCK_RESLOC_PREF_LEN));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static List<int[]> collectOldMetaBlockAlloc(Predicate<Material> filter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int[] buffer = new int[16];
        Arrays.fill(buffer, -1);
        int bufferPtr = 0;
        Iterator<Material> iterator = Material.MATERIAL_REGISTRY.iterator();
        while (iterator.hasNext()) {
            Material material = iterator.next();
            if (!filter.test(material)) continue;
            buffer[bufferPtr++] = Material.MATERIAL_REGISTRY.getIDForObject(material);
            if (bufferPtr < 16) continue;
            builder.add((Object)buffer);
            buffer = new int[16];
            Arrays.fill(buffer, -1);
            bufferPtr = 0;
        }
        if (bufferPtr > 0) {
            builder.add((Object)buffer);
        }
        return builder.build();
    }

    @Nullable
    public static NBTTagList getBlockRegistryTag(NBTTagCompound fmlTag) {
        NBTTagCompound tag;
        if (fmlTag.func_150297_b("Registries", 10) && (tag = fmlTag.func_74775_l("Registries")).func_150297_b("minecraft:blocks", 10) && (tag = tag.func_74775_l("minecraft:blocks")).func_150297_b("ids", 9)) {
            return tag.func_150295_c("ids", 10);
        }
        return null;
    }
}

