/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.TextFieldWidget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.ItemStackKey;
import gregtech.common.covers.filter.ItemFilter;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class OreDictionaryItemFilter
extends ItemFilter {
    private static final Pattern ORE_DICTIONARY_FILTER = Pattern.compile("\\*?[a-zA-Z0-9_]*\\*?");
    protected String oreDictionaryFilter = "";

    protected void setOreDictionaryFilter(String oreDictionaryFilter) {
        this.oreDictionaryFilter = oreDictionaryFilter;
        this.markDirty();
    }

    public String getOreDictionaryFilter() {
        return this.oreDictionaryFilter;
    }

    @Override
    public void initUI(Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new LabelWidget(10, 0, "cover.ore_dictionary_filter.title1", new Object[0]));
        widgetGroup.accept(new LabelWidget(10, 10, "cover.ore_dictionary_filter.title2", new Object[0]));
        widgetGroup.accept(new TextFieldWidget(10, 25, 100, 12, true, () -> this.oreDictionaryFilter, this::setOreDictionaryFilter).setMaxStringLength(64).setValidator(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches()));
    }

    @Override
    public Object matchItemStack(ItemStack itemStack) {
        return OreDictionaryItemFilter.matchesOreDictionaryFilter(this.getOreDictionaryFilter(), itemStack);
    }

    @Override
    public int getSlotTransferLimit(Object matchSlot, Set<ItemStackKey> matchedStacks, int globalTransferLimit) {
        return globalTransferLimit;
    }

    @Override
    public boolean showGlobalTransferLimitSlider() {
        return true;
    }

    @Override
    public int getTotalOccupiedHeight() {
        return 37;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("OreDictionaryFilter", this.oreDictionaryFilter);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        this.oreDictionaryFilter = tagCompound.func_74779_i("OreDictionaryFilter");
    }

    public static String matchesOreDictionaryFilter(String oreDictionaryFilter, ItemStack itemStack) {
        boolean endWildcard;
        if (oreDictionaryFilter.isEmpty()) {
            return null;
        }
        boolean startWildcard = oreDictionaryFilter.charAt(0) == '*';
        boolean bl = endWildcard = oreDictionaryFilter.length() > 1 && oreDictionaryFilter.charAt(oreDictionaryFilter.length() - 1) == '*';
        if (startWildcard) {
            oreDictionaryFilter = oreDictionaryFilter.substring(1);
        }
        if (endWildcard) {
            oreDictionaryFilter = oreDictionaryFilter.substring(0, oreDictionaryFilter.length() - 1);
        }
        for (String stackOreName : OreDictUnifier.getOreDictionaryNames(itemStack)) {
            if (!OreDictionaryItemFilter.areOreDictNamesEqual(startWildcard, endWildcard, oreDictionaryFilter, stackOreName)) continue;
            return stackOreName;
        }
        return null;
    }

    private static boolean areOreDictNamesEqual(boolean startWildcard, boolean endWildcard, String oreDictName, String stackOreName) {
        if (startWildcard && endWildcard) {
            return stackOreName.contains(oreDictName);
        }
        if (startWildcard) {
            return stackOreName.endsWith(oreDictName);
        }
        if (endWildcard) {
            return stackOreName.startsWith(oreDictName);
        }
        return stackOreName.equals(oreDictName);
    }
}

