/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.GTFluidUtils;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.covers.CoverPump;
import gregtech.common.covers.TransferMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.logging.log4j.message.FormattedMessage;

public class CoverFluidRegulator
extends CoverPump {
    protected TransferMode transferMode = TransferMode.TRANSFER_ANY;
    protected int keepAmount = 0;
    protected int supplyAmount = 0;
    private static final String supplyKey = "SupplyAmount";
    private static final String keepKey = "KeepAmount";

    public CoverFluidRegulator(ICoverable coverHolder, EnumFacing attachedSide, int tier, int mbPerTick) {
        super(coverHolder, attachedSide, tier, mbPerTick);
    }

    @Override
    protected int doTransferFluidsInternal(IFluidHandler myFluidHandler, IFluidHandler fluidHandler, int transferLimit) {
        IFluidHandler destHandler;
        IFluidHandler sourceHandler;
        if (this.pumpMode == CoverPump.PumpMode.IMPORT) {
            sourceHandler = fluidHandler;
            destHandler = myFluidHandler;
        } else if (this.pumpMode == CoverPump.PumpMode.EXPORT) {
            sourceHandler = myFluidHandler;
            destHandler = fluidHandler;
        } else {
            return 0;
        }
        switch (this.transferMode) {
            case TRANSFER_ANY: {
                return GTFluidUtils.transferFluids(sourceHandler, destHandler, transferLimit, this.fluidFilter::testFluidStack);
            }
            case KEEP_EXACT: {
                return this.doKeepExact(transferLimit, sourceHandler, destHandler, this.fluidFilter::testFluidStack, this.keepAmount);
            }
            case TRANSFER_EXACT: {
                return this.doTransferExact(transferLimit, sourceHandler, destHandler, this.fluidFilter::testFluidStack, this.supplyAmount);
            }
        }
        return 0;
    }

    protected int doTransferExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int supplyAmount) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            if (fluidLeftToTransfer < supplyAmount) break;
            FluidStack sourceFluid = tankProperties.getContents();
            if (sourceFluid == null || sourceFluid.amount == 0 || !fluidFilter.test(sourceFluid)) continue;
            sourceFluid.amount = supplyAmount;
            if (GTFluidUtils.transferExactFluidStack(sourceHandler, destHandler, sourceFluid.copy())) {
                fluidLeftToTransfer -= sourceFluid.amount;
            }
            if (fluidLeftToTransfer == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    protected int doKeepExact(int transferLimit, IFluidHandler sourceHandler, IFluidHandler destHandler, Predicate<FluidStack> fluidFilter, int keepAmount) {
        if (sourceHandler == null || destHandler == null || fluidFilter == null || keepAmount <= 0) {
            return 0;
        }
        Map<FluidStack, Integer> sourceFluids = this.collectDistinctFluids(sourceHandler, IFluidTankProperties::canDrain, fluidFilter);
        Map<FluidStack, Integer> destFluids = this.collectDistinctFluids(destHandler, IFluidTankProperties::canFill, fluidFilter);
        int transferred = 0;
        for (FluidStack fluidStack : sourceFluids.keySet()) {
            int drainable;
            int fillResult;
            FluidStack drainedResult;
            int amountToMove;
            if (transferred >= transferLimit) break;
            int amountInDest = destFluids.getOrDefault(fluidStack, 0);
            if (amountInDest >= keepAmount || (amountToMove = Math.min(transferLimit - transferred, keepAmount - amountInDest)) <= 0 || (drainedResult = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, amountToMove), false)) == null || drainedResult.amount <= 0 || !fluidStack.equals((Object)drainedResult) || (fillResult = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, drainable = Math.min(amountToMove, drainedResult.amount)), false)) <= 0) continue;
            int fluidToMove = Math.min(drainable, fillResult);
            FluidStack drainedActual = sourceHandler.drain(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (drainedActual == null) {
                throw new RuntimeException("Misbehaving fluid container: drain produced null after simulation succeeded");
            }
            if (!fluidStack.equals((Object)drainedActual)) {
                throw new RuntimeException("Misbehaving fluid container: drain produced a different fluid than the simulation");
            }
            if (drainedActual.amount != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: drain expected: {}, actual: {}", (Object)fluidToMove, (Object)drainedActual.amount).getFormattedMessage());
            }
            int filledActual = destHandler.fill(CoverFluidRegulator.copyFluidStackWithAmount(fluidStack, fluidToMove), true);
            if (filledActual != fluidToMove) {
                throw new RuntimeException(new FormattedMessage("Misbehaving fluid container: fill expected: {}, actual: {}", (Object)fluidToMove, (Object)filledActual).getFormattedMessage());
            }
            transferred += fluidToMove;
        }
        return transferred;
    }

    private static FluidStack copyFluidStackWithAmount(FluidStack fs, int amount) {
        FluidStack fs2 = fs.copy();
        fs2.amount = amount;
        return fs2;
    }

    private Map<FluidStack, Integer> collectDistinctFluids(IFluidHandler handler, Predicate<IFluidTankProperties> tankTypeFilter, Predicate<FluidStack> fluidTypeFilter) {
        HashMap<FluidStack, Integer> summedFluids = new HashMap<FluidStack, Integer>();
        Arrays.stream(handler.getTankProperties()).filter(tankTypeFilter).map(IFluidTankProperties::getContents).filter(Objects::nonNull).filter(fluidTypeFilter).forEach(fs -> {
            summedFluids.putIfAbsent((FluidStack)fs, 0);
            summedFluids.computeIfPresent((FluidStack)fs, (k, v) -> v + fs.amount);
        });
        return summedFluids;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.coverHolder.markDirty();
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    private boolean checkTransferMode() {
        return this.transferMode == TransferMode.TRANSFER_EXACT || this.transferMode == TransferMode.KEEP_EXACT;
    }

    private String getTransferSizeString() {
        int val;
        switch (this.transferMode) {
            case KEEP_EXACT: {
                val = this.keepAmount;
                break;
            }
            case TRANSFER_EXACT: {
                val = this.supplyAmount;
                break;
            }
            default: {
                val = -1;
            }
        }
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            val /= 1000;
        }
        return val == -1 ? "" : TextFormattingUtil.formatLongToCompactString(val);
    }

    protected void getHoverString(List<ITextComponent> textList) {
        switch (this.transferMode) {
            case KEEP_EXACT: {
                TextComponentString keepComponent = new TextComponentString(this.getTransferSizeString());
                TextComponentTranslation hoverKeep = new TextComponentTranslation("cover.fluid_regulator.keep_exact", new Object[]{this.keepAmount});
                keepComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverKeep));
                textList.add((ITextComponent)keepComponent);
                break;
            }
            case TRANSFER_EXACT: {
                TextComponentString supplyComponent = new TextComponentString(this.getTransferSizeString());
                TextComponentTranslation hoverSupply = new TextComponentTranslation("cover.fluid_regulator.supply_exact", new Object[]{this.supplyAmount});
                supplyComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverSupply));
                textList.add((ITextComponent)supplyComponent);
            }
        }
    }

    @Override
    public void setBucketMode(CoverPump.BucketMode bucketMode) {
        super.setBucketMode(bucketMode);
        if (this.bucketMode == CoverPump.BucketMode.BUCKET) {
            this.setKeepAmount(this.keepAmount / 1000 * 1000);
            this.setSupplyAmount(this.supplyAmount / 1000 * 1000);
        }
    }

    private void adjustTransferSize(int amount) {
        amount *= this.bucketMode == CoverPump.BucketMode.BUCKET ? 1000 : 1;
        switch (this.transferMode) {
            case TRANSFER_EXACT: {
                this.setSupplyAmount(MathHelper.func_76125_a((int)(this.supplyAmount + amount), (int)0, (int)this.transferRate));
            }
            case KEEP_EXACT: {
                this.setKeepAmount(MathHelper.func_76125_a((int)(this.keepAmount + amount), (int)0, (int)Integer.MAX_VALUE));
            }
        }
    }

    private void setKeepAmount(int keepAmount) {
        this.keepAmount = keepAmount;
        this.coverHolder.markDirty();
    }

    private void setSupplyAmount(int supplyAmount) {
        this.supplyAmount = supplyAmount;
        this.coverHolder.markDirty();
    }

    @Override
    protected String getUITitle() {
        return "cover.fluid_regulator.title";
    }

    @Override
    protected ModularUI buildUI(ModularUI.Builder builder, EntityPlayer player) {
        WidgetGroup filterGroup = new WidgetGroup();
        filterGroup.addWidget(new CycleButtonWidget(88, 63, 75, 18, TransferMode.class, this::getTransferMode, this::setTransferMode).setTooltipHoverString("cover.fluid_regulator.transfer_mode.description"));
        ServerWidgetGroup stackSizeGroup = new ServerWidgetGroup(this::checkTransferMode);
        stackSizeGroup.addWidget(new ClickButtonWidget(88, 84, 18, 18, "-1", data -> this.adjustTransferSize(data.isCtrlClick ? -100 : (data.isShiftClick ? -10 : -1))));
        stackSizeGroup.addWidget(new ClickButtonWidget(144, 84, 18, 18, "+1", data -> this.adjustTransferSize(data.isCtrlClick ? 100 : (data.isShiftClick ? 10 : 1))));
        stackSizeGroup.addWidget(new ImageWidget(108, 84, 34, 18, GuiTextures.DISPLAY));
        stackSizeGroup.addWidget(new AdvancedTextWidget(114, 89, this::getHoverString, 0xFFFFFF));
        return super.buildUI(builder.widget(filterGroup).widget(stackSizeGroup), player);
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("TransferMode", this.transferMode.ordinal());
        tagCompound.func_74768_a(keepKey, this.keepAmount);
        tagCompound.func_74768_a(supplyKey, this.supplyAmount);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.transferMode = TransferMode.values()[tagCompound.func_74762_e("TransferMode")];
        this.keepAmount = tagCompound.func_74762_e(keepKey);
        this.supplyAmount = tagCompound.func_74762_e(supplyKey);
    }
}

