/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.surfacerock;

import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.render.StoneRenderer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockSurfaceRock
extends Block {
    private static final AxisAlignedBB STONE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockSurfaceRock() {
        super(net.minecraft.block.material.Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c("surface_rock");
        this.func_149713_g(1);
    }

    public abstract Material getStoneMaterial(IBlockAccess var1, BlockPos var2, IBlockState var3);

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STONE_AABB;
    }

    private ItemStack getDropStack(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, int amount) {
        Material material = this.getStoneMaterial(blockAccess, pos, blockState);
        return OreDictUnifier.get(OrePrefix.dustTiny, material, amount);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getDropStack((IBlockAccess)world, pos, state, 1);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = new Random();
        int amount = 3 + rand.nextInt((int)(2.0 + (double)fortune * 1.5));
        drops.add((Object)this.getDropStack(world, pos, state, amount));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return StoneRenderer.BLOCK_RENDER_TYPE;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (fromPos.func_177984_a().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_193401_d((IBlockAccess)worldIn, fromPos, EnumFacing.UP) != BlockFaceShape.SOLID) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

