/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import net.minecraftforge.common.config.Config;

@Config(modid="gregtech")
public class ConfigHolder {
    @Config.Comment(value={"Whether to enable more verbose logging. Default: false"})
    public static boolean debug = false;
    @Config.Comment(value={"Whether to increase number of rolls for dungeon chests. Increases dungeon loot drastically. Default: true"})
    public static boolean increaseDungeonLoot = true;
    @Config.Comment(value={"Whether to hide facades of all blocks in JEI and creative search menu. Default: true"})
    @Config.RequiresMcRestart
    public static boolean hideFacadesInJEI = true;
    @Config.Comment(value={"Whether to hide filled cells in JEI and creative search menu. Default: true"})
    @Config.RequiresMcRestart
    public static boolean hideFilledCellsInJEI = true;
    @Config.Comment(value={"Whether to hide filled tanks in JEI and creative search menu. Default: true"})
    @Config.RequiresMcRestart
    public static boolean hideFilledTanksInJEI = true;
    @Config.Comment(value={"Specifies min amount of veins in section. Default: 0"})
    public static int minVeinsInSection = 0;
    @Config.Comment(value={"Specifies additional random amount of veins in section. Default: 2"})
    public static int additionalVeinsInSection = 2;
    @Config.Comment(value={"Whether veins should be generated in center of chunk. Default: false"})
    public static boolean generateVeinsInCenterOfChunk = false;
    @Config.Comment(value={"Whether to disable vanilla ores generation in world. Default: false"})
    public static boolean disableVanillaOres = false;
    @Config.Comment(value={"Whether to disable rubber tree world generation. Default: false"})
    @Config.RequiresMcRestart
    public static boolean disableRubberTreeGeneration = false;
    @Config.Comment(value={"Whether machines should explode when overloaded with power. Default: true"})
    public static boolean doExplosions = true;
    @Config.Comment(value={"Energy use multiplier for electric items. Default: 100"})
    public static int energyUsageMultiplier = 100;
    @Config.Comment(value={"Chance of generating abandoned base in chunk = 1 / THIS_VALUE. 0 disables abandoned base generation. Default: 1000"})
    public static int abandonedBaseRarity = 1000;
    @Config.RangeInt(min=0, max=100)
    @Config.Comment(value={"Chance with which flint and steel will create fire. Default: 50"})
    public static int flintChanceToCreateFire = 50;
    @Config.Comment(value={"Recipes for machine hulls use more materials. Default: false"})
    @Config.RequiresMcRestart
    public static boolean harderMachineHulls = false;
    @Config.Comment(value={"If true, insufficient energy supply will reset recipe progress to zero. If false, progress will decrease to zero with 2x speed. Default: false"})
    @Config.RequiresWorldRestart
    public static boolean insufficientEnergySupplyWipesRecipeProgress = false;
    @Config.Comment(value={"Whether to use modPriorities setting in config for prioritizing ore dictionary item registrations. By default, GTCE will sort ore dictionary registrations alphabetically comparing their owner ModIDs. Default: false"})
    @Config.RequiresMcRestart
    public static boolean useCustomModPriorities = false;
    @Config.Comment(value={"Specifies priorities of mods in ore dictionary item registration. First ModID has highest priority, last - lowest. Unspecified ModIDs follow standard sorting, but always have lower priority than last specified ModID.\nFor this to work \"useCustomModPriorities\" has to be set to true."})
    @Config.RequiresMcRestart
    public static String[] modPriorities = new String[0];
    @Config.Comment(value={"Setting this to true makes GTCE ignore error and invalid recipes that would otherwise cause crash. Default: true"})
    @Config.RequiresMcRestart
    public static boolean ignoreErrorOrInvalidRecipes = true;
    @Config.Comment(value={"Setting this to false causes GTCE to not register additional methane recipes for foods in the centrifuge. Default: true"})
    @Config.RequiresMcRestart
    public static boolean addFoodMethaneRecipes = true;
    @Config.Comment(value={"Category that contains configs for changing vanilla recipes"})
    @Config.RequiresMcRestart
    public static VanillaRecipes vanillaRecipes = new VanillaRecipes();
    @Config.Comment(value={"Category that contains configs for machines with specific behavior"})
    public static MachineSpecificConfiguration machineSpecific = new MachineSpecificConfiguration();
    @Config.Comment(value={"Category that contains configs for the NanoSaber"})
    public static NanoSaberConfiguration nanoSaberConfiguration = new NanoSaberConfiguration();
    @Config.Comment(value={"Sets the bonus EU output of Steam Turbines. Default: 6144"})
    @Config.RequiresMcRestart
    public static int steamTurbineBonusOutput = 6144;
    @Config.Comment(value={"Sets the bonus EU output of Plasma Turbines. Default: 6144"})
    @Config.RequiresMcRestart
    public static int plasmaTurbineBonusOutput = 6144;
    @Config.Comment(value={"Sets the bonus EU output of Gas Turbines. Default 6144"})
    @Config.RequiresMcRestart
    public static int gasTurbineBonusOutput = 6144;
    @Config.Comment(value={"If true, powered zero loss wires will damage the player. Default: false"})
    public static boolean doLosslessWiresDamage = false;
    @Config.Comment(value={"If true, lossless cables will have lossy wires. Default: false"})
    @Config.RequiresMcRestart
    public static boolean doLosslessWiresMakeLossyCables = false;

    public static class NanoSaberConfiguration {
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.Comment(value={"The additional damage added when the NanoSaber is powered. Default: 20.0"})
        @Config.RequiresMcRestart
        public double nanoSaberDamageBoost = 20.0;
        @Config.RangeDouble(min=0.0, max=100.0)
        @Config.Comment(value={"The base damage of the NanoSaber. Default: 5.0"})
        @Config.RequiresMcRestart
        public double nanoSaberBaseDamage = 5.0;
        @Config.Comment(value={"Should Zombies spawn with charged, active NanoSabers on hard difficulty? Default: true"})
        public boolean zombieSpawnWithSabers = true;
        @Config.RangeInt(min=1, max=512)
        @Config.Comment(value={"The EU/t consumption of the NanoSaber. Default: 64"})
        @Config.RequiresMcRestart
        public int energyConsumption = 64;
    }

    public static class MachineSpecificConfiguration {
        @Config.Comment(value={"Array of blacklisted dimension IDs in which Air Collector does not work."})
        public int[] airCollectorDimensionBlacklist = new int[0];
    }

    public static class VanillaRecipes {
        @Config.Comment(value={"Whether to nerf the paper crafting recipe. Default: true"})
        public boolean nerfPaperCrafting = true;
        @Config.Comment(value={"Whether to make flint and steel recipe require a steel nugget instead of an iron ingot. Default: true."})
        public boolean flintAndSteelRequireSteel = true;
        @Config.Comment(value={"Whether to nerf wood crafting to 2 planks from 1 log. Default: false"})
        public boolean nerfWoodCrafting = false;
        @Config.Comment(value={"Whether to nerf wood crafting to 2 sticks from 2 planks. Default: false"})
        public boolean nerfStickCrafting = false;
        @Config.Comment(value={"Whether to make the iron bucket recipe harder by requiring a hammer and plates. Default: true"})
        public boolean bucketRequirePlatesAndHammer = true;
        @Config.Comment(value={"Recipes for items like iron doors, trapdoors, pressure plates, cauldrons, hoppers, and iron bars require iron plates and a hammer. Default: true"})
        public boolean ironConsumingCraftingRecipesRequirePlates = true;
        @Config.Comment(value={"Whether crafting a bowl requires a knife instead of only planks. Default: true"})
        public boolean bowlRequireKnife = true;
    }
}

