/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GTValues;
import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.enchants.EnchantmentEnderDamage;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.crafttweaker.MetaItemBracketHandler;
import gregtech.api.recipes.recipeproperties.BlastTemperatureProperty;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTLog;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.CompressedItemBlock;
import gregtech.common.blocks.FrameItemBlock;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.OreItemBlock;
import gregtech.common.blocks.StoneItemBlock;
import gregtech.common.blocks.VariantItemBlock;
import gregtech.common.blocks.wood.BlockGregLeaves;
import gregtech.common.blocks.wood.BlockGregLog;
import gregtech.common.blocks.wood.BlockGregSapling;
import gregtech.common.datafix.GregTechDataFixers;
import gregtech.common.items.MetaItems;
import gregtech.common.items.potions.PotionFluids;
import gregtech.common.pipelike.cable.ItemBlockCable;
import gregtech.common.pipelike.fluidpipe.ItemBlockFluidPipe;
import gregtech.loaders.MaterialInfoLoader;
import gregtech.loaders.OreDictionaryLoader;
import gregtech.loaders.oreprocessing.DecompositionRecipeHandler;
import gregtech.loaders.oreprocessing.RecipeHandlerList;
import gregtech.loaders.oreprocessing.ToolRecipeHandler;
import gregtech.loaders.recipe.CraftingRecipeLoader;
import gregtech.loaders.recipe.MachineRecipeLoader;
import gregtech.loaders.recipe.MetaTileEntityLoader;
import gregtech.loaders.recipe.RecyclingRecipes;
import gregtech.loaders.recipe.WoodMachineRecipes;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gregtech")
public class CommonProxy {
    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GTLog.logger.info("Registering Blocks...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)MetaBlocks.MACHINE);
        registry.register((IForgeRegistryEntry)MetaBlocks.CABLE);
        registry.register((IForgeRegistryEntry)MetaBlocks.FLUID_PIPE);
        registry.register((IForgeRegistryEntry)MetaBlocks.FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.REINFORCED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.PETRIFIED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.REINFORCED_PETRIFIED_FOAM);
        registry.register((IForgeRegistryEntry)MetaBlocks.BOILER_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.BOILER_FIREBOX_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.METAL_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.TURBINE_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.MACHINE_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.MUTLIBLOCK_CASING);
        registry.register((IForgeRegistryEntry)MetaBlocks.WIRE_COIL);
        registry.register((IForgeRegistryEntry)MetaBlocks.WARNING_SIGN);
        registry.register((IForgeRegistryEntry)MetaBlocks.GRANITE);
        registry.register((IForgeRegistryEntry)MetaBlocks.MINERAL);
        registry.register((IForgeRegistryEntry)MetaBlocks.CONCRETE);
        registry.register((IForgeRegistryEntry)MetaBlocks.LOG);
        registry.register((IForgeRegistryEntry)MetaBlocks.LEAVES);
        registry.register((IForgeRegistryEntry)MetaBlocks.SAPLING);
        registry.register((IForgeRegistryEntry)MetaBlocks.CRUSHER_BLADE);
        registry.register((IForgeRegistryEntry)MetaBlocks.SURFACE_ROCK_NEW);
        MetaBlocks.COMPRESSED.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.SURFACE_ROCKS.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.FRAMES.values().stream().distinct().forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.ORES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBlocksLast(RegistryEvent.Register<Block> event) {
        PotionFluids.initPotionFluids();
        MetaBlocks.FLUID_BLOCKS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GTLog.logger.info("Registering Items...");
        IForgeRegistry registry = event.getRegistry();
        for (MetaItem<?> item : MetaItems.ITEMS) {
            registry.register(item);
            item.registerSubItems();
        }
        ToolRecipeHandler.initializeMetaItems();
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MACHINE, MachineItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.CABLE, ItemBlockCable::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.FLUID_PIPE, ItemBlockFluidPipe::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.BOILER_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.BOILER_FIREBOX_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.METAL_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.TURBINE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MACHINE_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MUTLIBLOCK_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WIRE_COIL, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.WARNING_SIGN, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.GRANITE, StoneItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.MINERAL, StoneItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.CONCRETE, StoneItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createMultiTexItemBlock(MetaBlocks.LOG, state -> ((BlockGregLog.LogVariant)((Object)((Object)state.func_177229_b(BlockGregLog.VARIANT)))).func_176610_l()));
        registry.register((IForgeRegistryEntry)CommonProxy.createMultiTexItemBlock(MetaBlocks.LEAVES, state -> ((BlockGregLog.LogVariant)((Object)((Object)state.func_177229_b(BlockGregLeaves.VARIANT)))).func_176610_l()));
        registry.register((IForgeRegistryEntry)CommonProxy.createMultiTexItemBlock(MetaBlocks.SAPLING, state -> ((BlockGregLog.LogVariant)((Object)((Object)state.func_177229_b(BlockGregSapling.VARIANT)))).func_176610_l()));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(MetaBlocks.CRUSHER_BLADE, ItemBlock::new));
        MetaBlocks.COMPRESSED.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, CompressedItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.FRAMES.values().stream().distinct().map(block -> CommonProxy.createItemBlock(block, FrameItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaBlocks.ORES.stream().map(block -> CommonProxy.createItemBlock(block, OreItemBlock::new)).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (BlockWireCoil.CoilType values : BlockWireCoil.CoilType.values()) {
            BlastTemperatureProperty.registerCoilType(values.getCoilTemperature(), values.getMaterial(), "tile.wire_coil." + values.func_176610_l() + ".name");
        }
        GTLog.logger.info("Registering ore dictionary...");
        MetaItems.registerOreDict();
        MetaBlocks.registerOreDict();
        OreDictionaryLoader.init();
        MaterialInfoLoader.init();
        GTLog.logger.info("Registering recipes...");
        MetaItems.registerRecipes();
        MachineRecipeLoader.init();
        CraftingRecipeLoader.init();
        MetaTileEntityLoader.init();
        RecipeHandlerList.register();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void runEarlyMaterialHandlers(RegistryEvent.Register<IRecipe> event) {
        GTLog.logger.info("Running early material handlers...");
        OrePrefix.runMaterialHandlers();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        GTLog.logger.info("Running late material handlers...");
        OrePrefix.runMaterialHandlers();
        DecompositionRecipeHandler.runRecipeGeneration();
        RecyclingRecipes.init();
        WoodMachineRecipes.init();
        if (GTValues.isModLoaded("crafttweaker")) {
            MetaItemBracketHandler.rebuildComponentRegistry();
        }
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        EnchantmentEnderDamage.INSTANCE.register(event);
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gregtech")) {
            ConfigManager.sync((String)"gregtech", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void modifyFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        CompressedItemBlock itemBlock;
        Material material;
        ItemStack stack = event.getItemStack();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == MetaBlocks.LOG) {
            event.setBurnTime(300);
        } else if (block == MetaBlocks.SAPLING) {
            event.setBurnTime(100);
        }
        if (stack.func_77973_b() instanceof CompressedItemBlock && (material = (Material)(itemBlock = (CompressedItemBlock)stack.func_77973_b()).getBlockState(stack).func_177229_b((IProperty)itemBlock.compressedBlock.variantProperty)) instanceof DustMaterial && ((DustMaterial)material).burnTime > 0) {
            double materialUnitsInBlock = (double)OrePrefix.block.getMaterialAmount(material) / 3628800.0;
            event.setBurnTime((int)(materialUnitsInBlock * (double)((DustMaterial)material).burnTime));
        }
    }

    private static <T extends Block> ItemBlock createMultiTexItemBlock(T block, Function<IBlockState, String> nameProducer) {
        ItemMultiTexture itemBlock = new ItemMultiTexture(block, block, stack -> {
            IBlockState blockState = block.func_176203_a(stack.func_77960_j());
            return (String)nameProducer.apply(blockState);
        });
        itemBlock.setRegistryName(block.getRegistryName());
        return itemBlock;
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(block.getRegistryName());
        return itemBlock;
    }

    public void onPreLoad() {
    }

    public void onLoad() {
        GregTechDataFixers.init();
    }

    public void onPostLoad() {
        WoodMachineRecipes.postInit();
    }
}

