/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import crafttweaker.annotations.ZenRegister;
import gregtech.api.util.FileUtility;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.filler.BlacklistedBlockFiller;
import gregtech.api.worldgen.filler.BlockFiller;
import gregtech.api.worldgen.filler.SimpleBlockFiller;
import gregtech.api.worldgen.generator.WorldGeneratorImpl;
import gregtech.api.worldgen.populator.FluidSpringPopulator;
import gregtech.api.worldgen.populator.IVeinPopulator;
import gregtech.api.worldgen.populator.SurfaceBlockPopulator;
import gregtech.api.worldgen.populator.SurfaceRockPopulator;
import gregtech.api.worldgen.shape.EllipsoidGenerator;
import gregtech.api.worldgen.shape.PlateGenerator;
import gregtech.api.worldgen.shape.ShapeGenerator;
import gregtech.api.worldgen.shape.SingleBlockGenerator;
import gregtech.api.worldgen.shape.SphereGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.io.IOUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;

@ZenClass(value="mods.gregtech.ore.WorldGenRegistry")
@ZenRegister
public class WorldGenRegistry {
    public static final WorldGenRegistry INSTANCE = new WorldGenRegistry();
    private final Map<String, Supplier<ShapeGenerator>> shapeGeneratorRegistry = new TreeMap<String, Supplier<ShapeGenerator>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Supplier<BlockFiller>> blockFillerRegistry = new TreeMap<String, Supplier<BlockFiller>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Supplier<IVeinPopulator>> veinPopulatorRegistry = new TreeMap<String, Supplier<IVeinPopulator>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<Integer, String> namedDimensions = new HashMap<Integer, String>();
    private final List<OreDepositDefinition> registeredDefinitions = new ArrayList<OreDepositDefinition>();
    private final Map<WorldProvider, WorldOreVeinCache> oreVeinCache = new WeakHashMap<WorldProvider, WorldOreVeinCache>();

    private WorldGenRegistry() {
    }

    public List<Map.Entry<Integer, OreDepositDefinition>> getCachedBiomeVeins(WorldProvider provider, Biome biome) {
        if (this.oreVeinCache.containsKey(provider)) {
            return this.oreVeinCache.get(provider).getBiomeEntry(biome);
        }
        WorldOreVeinCache worldOreVeinCache = new WorldOreVeinCache(provider);
        this.oreVeinCache.put(provider, worldOreVeinCache);
        return worldOreVeinCache.getBiomeEntry(biome);
    }

    public void initializeRegistry() {
        GTLog.logger.info("Initializing ore generation registry...");
        this.registerShapeGenerator("ellipsoid", EllipsoidGenerator::new);
        this.registerShapeGenerator("sphere", SphereGenerator::new);
        this.registerShapeGenerator("plate", PlateGenerator::new);
        this.registerShapeGenerator("single", SingleBlockGenerator::new);
        this.registerBlockFiller("simple", SimpleBlockFiller::new);
        this.registerBlockFiller("ignore_bedrock", () -> new BlacklistedBlockFiller(Lists.newArrayList((Object[])new IBlockState[]{Blocks.field_150357_h.func_176223_P()})));
        this.registerVeinPopulator("surface_rock", SurfaceRockPopulator::new);
        this.registerVeinPopulator("fluid_spring", FluidSpringPopulator::new);
        this.registerVeinPopulator("surface_block", SurfaceBlockPopulator::new);
        WorldGeneratorImpl worldGenerator = new WorldGeneratorImpl();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGenerator, (int)1);
        MinecraftForge.ORE_GEN_BUS.register((Object)worldGenerator);
        try {
            this.reinitializeRegisteredVeins();
        }
        catch (IOException | RuntimeException exception) {
            GTLog.logger.fatal("Failed to initialize worldgen registry.", (Throwable)exception);
        }
    }

    public void reinitializeRegisteredVeins() throws IOException {
        Path worldgenDefinition;
        JsonObject element;
        GTLog.logger.info("Reloading ore generation files from config...");
        this.registeredDefinitions.clear();
        this.oreVeinCache.clear();
        Path configPath = Loader.instance().getConfigDir().toPath().resolve("gregtech");
        Path dimensionsFile = configPath.resolve("dimensions.json");
        Path worldgenRootPath = configPath.resolve("worldgen");
        Path jarFileExtractLockOld = configPath.resolve(".worldgen_extracted");
        Path jarFileExtractLock = configPath.resolve("worldgen_extracted");
        if (!Files.exists(worldgenRootPath, new LinkOption[0])) {
            Files.createDirectories(worldgenRootPath, new FileAttribute[0]);
        }
        if (!Files.exists(dimensionsFile, new LinkOption[0])) {
            Files.createFile(dimensionsFile, new FileAttribute[0]);
            WorldGenRegistry.extractJarVeinDefinitions(configPath, dimensionsFile);
        }
        if (!Files.exists(jarFileExtractLock, new LinkOption[0]) && !Files.exists(jarFileExtractLockOld, new LinkOption[0]) || !Files.list(worldgenRootPath).findFirst().isPresent()) {
            if (!Files.exists(jarFileExtractLock, new LinkOption[0])) {
                Files.createFile(jarFileExtractLock, new FileAttribute[0]);
            }
            WorldGenRegistry.extractJarVeinDefinitions(configPath, worldgenRootPath);
        }
        this.gatherNamedDimensions(dimensionsFile);
        List worldgenFiles = Files.walk(worldgenRootPath, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".json")).filter(path -> Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
        Iterator iterator = worldgenFiles.iterator();
        while (iterator.hasNext() && (element = FileUtility.tryExtractFromFile(worldgenDefinition = (Path)iterator.next())) != null) {
            String depositName = worldgenRootPath.relativize(worldgenDefinition).toString();
            try {
                OreDepositDefinition deposit = new OreDepositDefinition(depositName);
                deposit.initializeFromConfig(element);
                this.registeredDefinitions.add(deposit);
            }
            catch (RuntimeException exception) {
                GTLog.logger.error("Failed to parse worldgen definition {} on path {}", (Object)depositName, (Object)worldgenDefinition, (Object)exception);
            }
        }
        GTLog.logger.info("Loaded {} worldgen definitions", (Object)this.registeredDefinitions.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void extractJarVeinDefinitions(Path configPath, Path targetPath) throws IOException {
        Path worldgenRootPath = configPath.resolve("worldgen");
        Path dimensionsRootPath = configPath.resolve("dimensions.json");
        FileSystem zipFileSystem = null;
        try {
            Path worldgenJarRootPath;
            URI sampleUri = WorldGenRegistry.class.getResource("/assets/gregtech/.gtassetsroot").toURI();
            if (sampleUri.getScheme().equals("jar") || sampleUri.getScheme().equals("zip")) {
                zipFileSystem = FileSystems.newFileSystem(sampleUri, Collections.emptyMap());
                worldgenJarRootPath = zipFileSystem.getPath("/assets/gregtech/worldgen", new String[0]);
            } else {
                if (!sampleUri.getScheme().equals("file")) throw new IllegalStateException("Unable to locate absolute path to worldgen root directory: " + sampleUri);
                worldgenJarRootPath = Paths.get(WorldGenRegistry.class.getResource("/assets/gregtech/worldgen").toURI());
            }
            if (targetPath.compareTo(worldgenRootPath) == 0) {
                GTLog.logger.info("Attempting extraction of standard worldgen definitions from {} to {}", (Object)worldgenJarRootPath, (Object)worldgenRootPath);
                List jarFiles = Files.walk(worldgenJarRootPath, new FileVisitOption[0]).filter(jarFile -> Files.isRegularFile(jarFile, new LinkOption[0])).filter(jarPath -> jarPath.compareTo(worldgenJarRootPath.resolve("dimensions.json")) != 0).collect(Collectors.toList());
                for (Path jarFile2 : jarFiles) {
                    Path worldgenPath = worldgenRootPath.resolve(worldgenJarRootPath.relativize(jarFile2).toString());
                    Files.createDirectories(worldgenPath.getParent(), new FileAttribute[0]);
                    Files.copy(jarFile2, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                }
                GTLog.logger.info("Extracted {} builtin worldgen definitions into worldgen folder", (Object)jarFiles.size());
            } else if (targetPath.compareTo(dimensionsRootPath) == 0) {
                GTLog.logger.info("Attempting extraction of standard dimension definitions from {} to {}", (Object)worldgenJarRootPath, (Object)dimensionsRootPath);
                Path dimensionFile = worldgenJarRootPath.resolve("dimensions.json");
                Path worldgenPath = dimensionsRootPath.resolve(worldgenJarRootPath.relativize(worldgenJarRootPath).toString());
                Files.copy(dimensionFile, worldgenPath, StandardCopyOption.REPLACE_EXISTING);
                GTLog.logger.info("Extracted builtin dimension definitions into worldgen folder");
            }
            if (zipFileSystem == null) return;
        }
        catch (URISyntaxException impossible) {
            try {
                throw new RuntimeException(impossible);
            }
            catch (Throwable throwable) {
                if (zipFileSystem == null) throw throwable;
                IOUtils.closeQuietly(zipFileSystem);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)zipFileSystem);
        return;
    }

    private void gatherNamedDimensions(Path dimensionsFile) {
        JsonObject element = FileUtility.tryExtractFromFile(dimensionsFile);
        if (element == null) {
            return;
        }
        try {
            JsonArray dims = element.getAsJsonArray("dims");
            for (JsonElement dim : dims) {
                this.namedDimensions.put(dim.getAsJsonObject().get("dimID").getAsInt(), dim.getAsJsonObject().get("dimName").getAsString());
            }
        }
        catch (RuntimeException exception) {
            GTLog.logger.error("Failed to parse named dimensions", (Throwable)exception);
        }
    }

    public void registerShapeGenerator(String identifier, Supplier<ShapeGenerator> shapeGeneratorSupplier) {
        if (this.shapeGeneratorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.shapeGeneratorRegistry.put(identifier, shapeGeneratorSupplier);
    }

    public void registerBlockFiller(String identifier, Supplier<BlockFiller> blockFillerSupplier) {
        if (this.blockFillerRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.blockFillerRegistry.put(identifier, blockFillerSupplier);
    }

    public void registerVeinPopulator(String identifier, Supplier<IVeinPopulator> veinPopulatorSupplier) {
        if (this.veinPopulatorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("Identifier already occupied:" + identifier);
        }
        this.veinPopulatorRegistry.put(identifier, veinPopulatorSupplier);
    }

    public ShapeGenerator createShapeGenerator(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.shapeGeneratorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No shape generator found for type " + identifier);
        }
        ShapeGenerator shapeGenerator = this.shapeGeneratorRegistry.get(identifier).get();
        shapeGenerator.loadFromConfig(object);
        return shapeGenerator;
    }

    public BlockFiller createBlockFiller(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.blockFillerRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No block filler found for type " + identifier);
        }
        BlockFiller blockFiller = this.blockFillerRegistry.get(identifier).get();
        blockFiller.loadFromConfig(object);
        return blockFiller;
    }

    public IVeinPopulator createVeinPopulator(JsonObject object) {
        String identifier = object.get("type").getAsString();
        if (!this.veinPopulatorRegistry.containsKey(identifier)) {
            throw new IllegalArgumentException("No vein populator found for type " + identifier);
        }
        IVeinPopulator veinPopulator = this.veinPopulatorRegistry.get(identifier).get();
        veinPopulator.loadFromConfig(object);
        return veinPopulator;
    }

    @ZenGetter(value="oreDeposits")
    public static List<OreDepositDefinition> getOreDeposits() {
        return Collections.unmodifiableList(WorldGenRegistry.INSTANCE.registeredDefinitions);
    }

    public static Map<Integer, String> getNamedDimensions() {
        return WorldGenRegistry.INSTANCE.namedDimensions;
    }

    private class WorldOreVeinCache {
        private final List<OreDepositDefinition> worldVeins;
        private final Map<Biome, List<Map.Entry<Integer, OreDepositDefinition>>> biomeVeins = new HashMap<Biome, List<Map.Entry<Integer, OreDepositDefinition>>>();

        public WorldOreVeinCache(WorldProvider worldProvider) {
            this.worldVeins = WorldGenRegistry.this.registeredDefinitions.stream().filter(definition -> definition.getDimensionFilter().test(worldProvider)).collect(Collectors.toList());
        }

        private List<Map.Entry<Integer, OreDepositDefinition>> getBiomeEntry(Biome biome) {
            if (this.biomeVeins.containsKey(biome)) {
                return this.biomeVeins.get(biome);
            }
            List<Map.Entry<Integer, OreDepositDefinition>> result = this.worldVeins.stream().map(vein -> new AbstractMap.SimpleEntry<Integer, OreDepositDefinition>(vein.getWeight() + vein.getBiomeWeightModifier().apply(biome), (OreDepositDefinition)vein)).filter(entry -> (Integer)entry.getKey() > 0).collect(Collectors.toList());
            this.biomeVeins.put(biome, result);
            return result;
        }
    }
}

