/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class WorldConfigUtils {
    public static Predicate<WorldProvider> createWorldPredicate(JsonElement element) {
        Preconditions.checkArgument((boolean)element.isJsonArray(), (Object)"World filter should be array!");
        JsonArray predicateArray = element.getAsJsonArray();
        ArrayList<Predicate<WorldProvider>> allPredicates = new ArrayList<Predicate<WorldProvider>>();
        for (JsonElement worldPredicate : predicateArray) {
            String stringValue = worldPredicate.getAsString();
            if (stringValue.equals("is_surface_world")) {
                allPredicates.add(WorldProvider::func_76569_d);
                continue;
            }
            if (stringValue.equals("is_nether")) {
                allPredicates.add(wp -> wp.func_177495_o() || wp.func_186058_p() == DimensionType.NETHER);
                continue;
            }
            Function<WorldProvider, String> stringSupplier = null;
            if (stringValue.startsWith("dimension_id:")) {
                String filterValue = stringValue.substring(13);
                if (filterValue.indexOf(58) == -1) {
                    int dimensionId = Integer.parseInt(filterValue);
                    allPredicates.add(provider -> provider.getDimension() == dimensionId);
                } else {
                    int indexOf = filterValue.indexOf(58);
                    int indexOfExclusive = indexOf + 1;
                    int minDimensionId = indexOf == 0 ? -2147483647 : Integer.parseInt(filterValue.substring(0, indexOf));
                    int maxDimensionId = indexOfExclusive == filterValue.length() ? Integer.MAX_VALUE : Integer.parseInt(filterValue.substring(indexOfExclusive));
                    allPredicates.add(provider -> provider.getDimension() >= minDimensionId && provider.getDimension() <= maxDimensionId);
                }
            } else if (stringValue.startsWith("name:")) {
                stringSupplier = provider -> provider.func_186058_p().func_186065_b();
                stringValue = stringValue.substring(5);
            } else if (stringValue.startsWith("provider_class:")) {
                stringSupplier = provider -> provider.getClass().getSimpleName();
                stringValue = stringValue.substring(15);
            } else {
                throw new IllegalArgumentException("Unknown world predicate: " + stringValue);
            }
            if (stringSupplier == null) continue;
            if (stringValue.startsWith("*")) {
                Pattern pattern = Pattern.compile(stringValue.substring(1));
                Function<WorldProvider, String> finalStringSupplier = stringSupplier;
                allPredicates.add(provider -> pattern.matcher((CharSequence)finalStringSupplier.apply((WorldProvider)provider)).matches());
                continue;
            }
            String finalStringValue = stringValue;
            Function<WorldProvider, String> finalStringSupplier1 = stringSupplier;
            allPredicates.add(provider -> finalStringValue.equalsIgnoreCase((String)finalStringSupplier1.apply((WorldProvider)provider)));
        }
        return provider -> allPredicates.stream().anyMatch(p -> p.test(provider));
    }

    public static Function<Biome, Integer> createBiomeWeightModifier(JsonElement element) {
        String influenceType;
        if (!element.isJsonObject()) {
            throw new IllegalArgumentException("Biome weight modifier should be object!");
        }
        JsonObject object = element.getAsJsonObject();
        switch (influenceType = object.get("type").getAsString()) {
            case "biome_map": {
                HashMap<Biome, Integer> backedMap = new HashMap<Biome, Integer>();
                for (Map.Entry elementEntry : object.entrySet()) {
                    if (((String)elementEntry.getKey()).equals("type")) continue;
                    ResourceLocation biomeName = new ResourceLocation((String)elementEntry.getKey());
                    Biome biome2 = (Biome)GameRegistry.findRegistry(Biome.class).getValue(biomeName);
                    if (biome2 == null) {
                        throw new IllegalArgumentException("Couldn't find biome with name " + biomeName);
                    }
                    backedMap.put(biome2, ((JsonElement)elementEntry.getValue()).getAsInt());
                }
                return biome -> backedMap.getOrDefault(biome, 0);
            }
            case "biome_dictionary": {
                HashMap<BiomeDictionary.Type, Integer> backedMap = new HashMap<BiomeDictionary.Type, Integer>();
                for (Map.Entry elementEntry : object.entrySet()) {
                    if (((String)elementEntry.getKey()).equals("type")) continue;
                    String tagName = ((String)elementEntry.getKey()).toUpperCase();
                    BiomeDictionary.Type type = GTUtility.getBiomeTypeTagByName(tagName);
                    if (type == null) {
                        throw new IllegalArgumentException("Couldn't find biome dictionary tag " + tagName);
                    }
                    backedMap.put(type, ((JsonElement)elementEntry.getValue()).getAsInt());
                }
                return biome -> {
                    int totalModifier = 0;
                    for (BiomeDictionary.Type type : backedMap.keySet()) {
                        if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                        totalModifier += ((Integer)backedMap.get(type)).intValue();
                    }
                    return totalModifier;
                };
            }
        }
        throw new IllegalArgumentException("Unknown biome influence type: " + influenceType);
    }
}

