/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version> {
    private final int[] nums;

    public Version(int ... nums) {
        if (nums.length == 0) {
            throw new IllegalArgumentException("Must be at least one version number!");
        }
        for (int num : nums) {
            if (num >= 0) continue;
            throw new IllegalArgumentException("Version numbers must be positive!");
        }
        this.nums = nums;
    }

    public static Version parse(String vStr) {
        return new Version(Arrays.stream(vStr.split(Pattern.quote("."))).mapToInt(Integer::parseInt).toArray());
    }

    public int getNumber(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index must be nonnegative!");
        }
        return index < this.nums.length ? this.nums[index] : 0;
    }

    @Override
    public int compareTo(Version o) {
        int numBound = Math.max(this.nums.length, o.nums.length);
        for (int i = 0; i < numBound; ++i) {
            int cmp = Integer.compare(this.getNumber(i), o.getNumber(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.nums.length; ++i) {
            hash ^= Integer.rotateLeft(this.nums[i], i * 7);
        }
        return hash;
    }

    public String toString() {
        return this.toString(this.nums.length);
    }

    public String toString(int sigPlaces) {
        return Arrays.stream(this.nums, 0, Math.min(sigPlaces, this.nums.length)).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }
}

