/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.util.function.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="gregtech")
public class TaskScheduler {
    private static Map<World, List<Task>> tasksPerWorld = new HashMap<World, List<Task>>();

    public static void scheduleTask(World world, Task task) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Attempt to schedule task on client world!");
        }
        List taskList = tasksPerWorld.computeIfAbsent(world, k -> new ArrayList());
        taskList.add(task);
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            tasksPerWorld.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            List taskList = tasksPerWorld.getOrDefault(event.world, Collections.emptyList());
            taskList.removeIf(task -> !task.run());
        }
    }
}

