/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class StreamUtils {
    public static Stream<ItemStack> streamFrom(IItemHandler inventory) {
        return StreamSupport.stream(StreamUtils.iterableFrom(inventory).spliterator(), false);
    }

    public static Iterable<ItemStack> iterableFrom(final IItemHandler inventory) {
        return new Iterable<ItemStack>(){

            @Override
            public Iterator<ItemStack> iterator() {
                return new Iterator<ItemStack>(){
                    private int cursor = 0;

                    @Override
                    public boolean hasNext() {
                        return this.cursor < inventory.getSlots();
                    }

                    @Override
                    public ItemStack next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ItemStack next = inventory.getStackInSlot(this.cursor);
                        ++this.cursor;
                        return next;
                    }
                };
            }

            @Override
            public Spliterator<ItemStack> spliterator() {
                return Spliterators.spliterator(this.iterator(), (long)inventory.getSlots(), 0);
            }
        };
    }
}

