/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static ItemStackHashStrategyBuilder builder() {
        return new ItemStackHashStrategyBuilder();
    }

    public static ItemStackHashStrategy comparingAllButCount() {
        return ItemStackHashStrategy.builder().compareItem(true).compareDamage(true).compareTag(true).build();
    }

    public static class ItemStackHashStrategyBuilder {
        private boolean item;
        private boolean count;
        private boolean damage;
        private boolean tag;

        public ItemStackHashStrategyBuilder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareCount(boolean choice) {
            this.count = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareDamage(boolean choice) {
            this.damage = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    return o == null || o.func_190926_b() ? 0 : Objects.hash(item ? o.func_77973_b() : null, count ? Integer.valueOf(o.func_190916_E()) : null, damage ? Integer.valueOf(o.func_77952_i()) : null, tag ? o.func_77978_p() : null);
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.func_190926_b()) {
                        return b == null || b.func_190926_b();
                    }
                    if (b == null || b.func_190926_b()) {
                        return false;
                    }
                    return !(item && a.func_77973_b() != b.func_77973_b() || count && a.func_190916_E() != b.func_190916_E() || damage && a.func_77952_i() != b.func_77952_i() || tag && !Objects.equals(a.func_77978_p(), b.func_77978_p()));
                }
            };
        }
    }
}

