/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.unification.material.Materials;
import gregtech.api.unification.stack.MaterialStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidTooltipUtil {
    private static final Map<Fluid, String> tooltips = new HashMap<Fluid, String>();

    public static boolean registerTooltip(Fluid fluid, String tooltip) {
        if (fluid != null && tooltip != null && !tooltip.isEmpty()) {
            tooltips.put(fluid, tooltip);
            return true;
        }
        return false;
    }

    public static String getFluidTooltip(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        return tooltips.get(fluid);
    }

    public static String getFluidTooltip(FluidStack stack) {
        if (stack == null) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(stack.getFluid());
    }

    public static String getFluidTooltip(String fluidName) {
        if (fluidName == null || fluidName.isEmpty()) {
            return null;
        }
        return FluidTooltipUtil.getFluidTooltip(FluidRegistry.getFluid((String)fluidName));
    }

    public static String getWaterTooltip() {
        return new MaterialStack(Materials.Hydrogen, 2L).toString() + "O";
    }
}

