/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.CTCubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TankRenderer
extends CTCubeRenderer {
    public TankRenderer(String basePath) {
        super(basePath);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderFluid(CCRenderState renderState, Matrix4 translation, int connectionMask, double fillPercent, FluidStack fluidStack) {
        if (fluidStack != null) {
            int resultFluidColor;
            int fluidStackColor = fluidStack.getFluid().getColor(fluidStack);
            double fluidLevelOffset = TankRenderer.offset(EnumFacing.UP, connectionMask) + TankRenderer.offset(EnumFacing.DOWN, connectionMask);
            double fluidLevel = fillPercent * (1.0 - fluidLevelOffset);
            Cuboid6 resultFluidCuboid = TankRenderer.createFullOffsetCuboid(connectionMask);
            if (fluidStack.getFluid().isGaseous(fluidStack)) {
                int opacity = (int)(fillPercent * 255.0);
                resultFluidColor = GTUtility.convertRGBtoRGBA_CL(fluidStackColor, opacity);
            } else {
                resultFluidCuboid.max.y = resultFluidCuboid.min.y + fluidLevel;
                resultFluidColor = GTUtility.convertRGBtoOpaqueRGBA_CL(fluidStackColor);
            }
            ColourMultiplier multiplier = new ColourMultiplier(resultFluidColor);
            IVertexOperation[] fluidPipeline = new IVertexOperation[]{multiplier};
            TextureAtlasSprite fluidSprite = TextureUtils.getTexture((ResourceLocation)fluidStack.getFluid().getStill(fluidStack));
            for (EnumFacing renderSide : EnumFacing.field_82609_l) {
                if (TankRenderer.hasFaceBit(connectionMask, renderSide)) continue;
                Textures.renderFace(renderState, translation, fluidPipeline, renderSide, resultFluidCuboid, fluidSprite);
            }
        }
    }

    private static Cuboid6 createFullOffsetCuboid(int connectionMask) {
        Cuboid6 cuboid6 = new Cuboid6();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            double offset = TankRenderer.offset(side, connectionMask);
            double value = side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1.0 - offset : offset;
            cuboid6.setSide(side, value);
        }
        return cuboid6;
    }

    private static double offset(EnumFacing side, int connectionMask) {
        return TankRenderer.hasFaceBit(connectionMask, side) ? 0.0 : 0.003;
    }
}

