/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OrientedOverlayRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    private OverlayFace[] faces;
    @SideOnly(value=Side.CLIENT)
    private Map<OverlayFace, ActivePredicate> sprites;

    public OrientedOverlayRenderer(String basePath, OverlayFace ... faces) {
        this.basePath = basePath;
        this.faces = faces;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new HashMap<OverlayFace, ActivePredicate>();
        for (OverlayFace overlayFace : this.faces) {
            String faceName = overlayFace.name().toLowerCase();
            ResourceLocation normalLocation = new ResourceLocation("gregtech", String.format("blocks/%s/overlay_%s", this.basePath, faceName));
            ResourceLocation activeLocation = new ResourceLocation("gregtech", String.format("blocks/%s/overlay_%s_active", this.basePath, faceName));
            TextureAtlasSprite normalSprite = textureMap.func_174942_a(normalLocation);
            TextureAtlasSprite activeSprite = textureMap.func_174942_a(activeLocation);
            this.sprites.put(overlayFace, new ActivePredicate(normalSprite, activeSprite));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] ops, Cuboid6 bounds, EnumFacing frontFacing, boolean isActive) {
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            OverlayFace overlayFace = OverlayFace.bySide(renderSide, frontFacing);
            if (!this.sprites.containsKey((Object)overlayFace)) continue;
            TextureAtlasSprite renderSprite = this.sprites.get((Object)overlayFace).getSprite(isActive);
            Textures.renderFace(renderState, translation, ops, renderSide, bounds, renderSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing frontFacing, boolean isActive) {
        this.render(renderState, translation, pipeline, Cuboid6.full, frontFacing, isActive);
    }

    @SideOnly(value=Side.CLIENT)
    private static class ActivePredicate {
        private TextureAtlasSprite normalSprite;
        private TextureAtlasSprite activeSprite;

        public ActivePredicate(TextureAtlasSprite normalSprite, TextureAtlasSprite activeSprite) {
            this.normalSprite = normalSprite;
            this.activeSprite = activeSprite;
        }

        public TextureAtlasSprite getSprite(boolean active) {
            return active ? this.activeSprite : this.normalSprite;
        }
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;


        public static OverlayFace bySide(EnumFacing side, EnumFacing frontFacing) {
            if (side == frontFacing) {
                return FRONT;
            }
            if (side.func_176734_d() == frontFacing) {
                return BACK;
            }
            if (side == EnumFacing.UP) {
                return TOP;
            }
            if (side == EnumFacing.DOWN) {
                return BOTTOM;
            }
            return SIDE;
        }
    }
}

