/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import gregtech.api.render.Textures;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChestRenderer
implements TextureUtils.IIconRegister {
    private static final Cuboid6 mainBox = new Cuboid6(0.0625, 0.0625, 0.0625, 0.9375, 0.625, 0.9375);
    private static final Cuboid6 capBox = new Cuboid6(0.0625, 0.5625, 0.0625, 0.9375, 0.875, 0.9375);
    private static final Cuboid6 lockBox = new Cuboid6(0.4375, 0.5, 0.0, 0.5625, 0.75, 0.0625);
    private static final List<EnumFacing> rotations = Arrays.asList(EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST);
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] textures;

    public ChestRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        String formattedBase = "gregtech:blocks/" + this.basePath;
        this.textures = new TextureAtlasSprite[7];
        this.textures[0] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/base_bottom"));
        this.textures[1] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/base_top"));
        this.textures[2] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/base_side"));
        this.textures[3] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/base_front"));
        this.textures[4] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/cap_bottom"));
        this.textures[5] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/cap_top"));
        this.textures[6] = textureMap.func_174942_a(new ResourceLocation(formattedBase + "/lock"));
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, EnumFacing rotation, float capRotation) {
        translation.translate(0.5, 0.5, 0.5);
        translation.rotate(Math.toRadians(90.0 * (double)rotations.indexOf(rotation)), Rotation.axes[1]);
        translation.translate(-0.5, -0.5, -0.5);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            TextureAtlasSprite baseSprite = renderSide.func_176740_k() == EnumFacing.Axis.Y ? this.textures[renderSide.func_176745_a()] : (renderSide == EnumFacing.NORTH ? this.textures[3] : this.textures[2]);
            Textures.renderFace(renderState, translation, pipeline, renderSide, mainBox, baseSprite);
        }
        translation.translate(0.5, 0.5625, 0.9375);
        translation.rotate(Math.toRadians(capRotation), Rotation.axes[5]);
        translation.translate(-0.5, -0.5625, -0.9375);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            TextureAtlasSprite capSprite = renderSide.func_176740_k() == EnumFacing.Axis.Y ? this.textures[4 + renderSide.func_176745_a()] : (renderSide == EnumFacing.NORTH ? this.textures[3] : this.textures[2]);
            TextureAtlasSprite lockSprite = this.textures[6];
            Textures.renderFace(renderState, translation, pipeline, renderSide, capBox, capSprite);
            Textures.renderFace(renderState, translation, pipeline, renderSide, lockBox, lockSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.textures[0];
    }
}

