/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.ingredients;

import gregtech.common.items.MetaItems;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class IntCircuitIngredient
extends Ingredient {
    public static final int CIRCUIT_MAX = 32;
    private final int[] matchingConfigurations;

    public static ItemStack getIntegratedCircuit(int configuration) {
        ItemStack stack = MetaItems.INTEGRATED_CIRCUIT.getStackForm();
        IntCircuitIngredient.setCircuitConfiguration(stack, configuration);
        return stack;
    }

    public static void setCircuitConfiguration(ItemStack itemStack, int configuration) {
        if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack)) {
            throw new IllegalArgumentException("Given item stack is not an integrated circuit!");
        }
        if (configuration < 0 || configuration > 32) {
            throw new IllegalArgumentException("Given configuration number is out of range!");
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("Configuration", configuration);
    }

    public static int getCircuitConfiguration(ItemStack itemStack) {
        if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack) || !itemStack.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        return tagCompound.func_74762_e("Configuration");
    }

    private static ItemStack[] gatherMatchingCircuits(int ... matchingConfigurations) {
        ItemStack[] resultItems = new ItemStack[matchingConfigurations.length];
        for (int i = 0; i < resultItems.length; ++i) {
            resultItems[i] = IntCircuitIngredient.getIntegratedCircuit(matchingConfigurations[i]);
        }
        return resultItems;
    }

    public IntCircuitIngredient(int ... matchingConfigurations) {
        super(IntCircuitIngredient.gatherMatchingCircuits(matchingConfigurations));
        this.matchingConfigurations = matchingConfigurations;
    }

    public boolean apply(@Nullable ItemStack itemStack) {
        return itemStack != null && MetaItems.INTEGRATED_CIRCUIT.isItemEqual(itemStack) && ArrayUtils.contains((int[])this.matchingConfigurations, (int)IntCircuitIngredient.getCircuitConfiguration(itemStack));
    }

    public boolean isSimple() {
        return false;
    }
}

