/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.mc1120.item.MCItemStack;
import crafttweaker.zenscript.IBracketHandler;
import gregtech.api.items.materialitem.MaterialMetaItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.unification.OreDictUnifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;

@BracketHandler
@ZenRegister
public class MetaItemBracketHandler
implements IBracketHandler {
    private static final Map<String, ItemStack> metaItemNames = new HashMap<String, ItemStack>();
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(MetaItemBracketHandler.class, (String)"getMetaItem", (Class[])new Class[]{String.class});

    public static void rebuildComponentRegistry() {
        metaItemNames.clear();
        for (MetaItem<?> item : MetaItem.getMetaItems()) {
            if (item instanceof MaterialMetaItem) {
                for (ItemStack itemStack : ((MaterialMetaItem)item).getEntries()) {
                    metaItemNames.put(OreDictUnifier.getPrefix(itemStack).name() + OreDictUnifier.getMaterial((ItemStack)itemStack).material.toCamelCaseString(), itemStack);
                }
            }
            for (MetaItem.MetaValueItem metaValueItem : item.getAllItems()) {
                if (metaValueItem.unlocalizedName.equals("meta_item")) continue;
                metaItemNames.put(metaValueItem.unlocalizedName, metaValueItem.getStackForm());
            }
        }
    }

    public static IItemStack getMetaItem(String name) {
        ItemStack item = metaItemNames.get(name);
        if (item != null) {
            return new MCItemStack(item);
        }
        return null;
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() < 3) {
            return null;
        }
        if (!tokens.get(0).getValue().equalsIgnoreCase("metaitem")) {
            return null;
        }
        if (!tokens.get(1).getValue().equals(":")) {
            return null;
        }
        StringBuilder nameBuilder = new StringBuilder();
        for (int i = 2; i < tokens.size(); ++i) {
            nameBuilder.append(tokens.get(i).getValue());
        }
        return position -> new ExpressionCallStatic(position, environment, this.method, new Expression[]{new ExpressionString(position, nameBuilder.toString())});
    }
}

