/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import com.google.common.collect.ImmutableMap;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.ImplosionExplosiveProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import stanhebben.zenscript.annotations.ZenMethod;

public class ImplosionRecipeBuilder
extends RecipeBuilder<ImplosionRecipeBuilder> {
    protected int explosivesAmount;
    protected ItemStack explosivesType;

    public ImplosionRecipeBuilder() {
    }

    public ImplosionRecipeBuilder(Recipe recipe, RecipeMap<ImplosionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
        this.explosivesType = recipe.getRecipePropertyStorage().getRecipePropertyValue(ImplosionExplosiveProperty.getInstance(), ItemStack.field_190927_a);
    }

    public ImplosionRecipeBuilder(RecipeBuilder<ImplosionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ImplosionRecipeBuilder copy() {
        return new ImplosionRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(String key, Object value) {
        if (key.equals("explosives")) {
            this.explosivesAmount((Integer)value);
            return true;
        }
        return false;
    }

    @Override
    public boolean applyProperty(String key, ItemStack exploType) {
        if (key.equals("explosives")) {
            this.explosivesAmount(exploType.func_190916_E());
            this.explosivesType = exploType;
            return true;
        }
        return false;
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosivesAmount(int explosivesAmount) {
        if (!GTUtility.isBetweenInclusive(1L, 64L, explosivesAmount)) {
            GTLog.logger.error("Amount of explosives should be from 1 to 64 inclusive", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.explosivesAmount = explosivesAmount;
        return this;
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosivesType(ItemStack explosivesType) {
        this.explosivesType = explosivesType;
        return this;
    }

    @Override
    public ValidationResult<Recipe> build() {
        int amount = Math.max(1, this.explosivesAmount / 2);
        this.explosivesType = this.explosivesType == null ? new ItemStack(Blocks.field_150335_W, amount) : new ItemStack(this.explosivesType.func_77973_b(), amount, this.explosivesType.func_77960_j());
        this.inputs.add(CountableIngredient.from(this.explosivesType));
        Recipe recipe = new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden);
        if (!recipe.getRecipePropertyStorage().store((Map<RecipeProperty<?>, Object>)ImmutableMap.of((Object)ImplosionExplosiveProperty.getInstance(), (Object)this.explosivesType))) {
            return ValidationResult.newResult(EnumValidationResult.INVALID, recipe);
        }
        return ValidationResult.newResult(this.finalizeAndValidate(), recipe);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(ImplosionExplosiveProperty.getInstance().getKey(), (Object)this.explosivesType).toString();
    }
}

