/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.util.ValidationResult;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;

public class ArcFurnaceRecipeBuilder
extends RecipeBuilder<ArcFurnaceRecipeBuilder> {
    public ArcFurnaceRecipeBuilder() {
    }

    public ArcFurnaceRecipeBuilder(Recipe recipe, RecipeMap<ArcFurnaceRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public ArcFurnaceRecipeBuilder(RecipeBuilder<ArcFurnaceRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ArcFurnaceRecipeBuilder copy() {
        return new ArcFurnaceRecipeBuilder(this);
    }

    @Override
    public void buildAndRegister() {
        if (this.fluidInputs.isEmpty()) {
            this.fluidInputs(Materials.Oxygen.getFluid(this.duration));
            for (FluidMaterial material : new FluidMaterial[]{Materials.Argon, Materials.Nitrogen}) {
                int plasmaAmount = (int)Math.max(1L, (long)this.duration / (material.getAverageMass() * 16L));
                SimpleRecipeBuilder builder = (SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.PLASMA_ARC_FURNACE_RECIPES.recipeBuilder().inputsIngredients(this.inputs)).outputs((Collection<ItemStack>)this.outputs)).duration(Math.max(1, this.duration / 16))).EUt(this.EUt / 3)).fluidInputs(material.getPlasma(plasmaAmount))).fluidOutputs(material.getFluid(plasmaAmount));
                builder.buildAndRegister();
            }
        }
        super.buildAndRegister();
    }

    @Override
    public ValidationResult<Recipe> build() {
        return ValidationResult.newResult(this.finalizeAndValidate(), new Recipe(this.inputs, (List<ItemStack>)this.outputs, this.chancedOutputs, this.fluidInputs, this.fluidOutputs, this.duration, this.EUt, this.hidden));
    }
}

