/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.recipes.FluidKey;
import gregtech.api.recipes.MatchingMode;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.builders.IntCircuitRecipeBuilder;
import gregtech.api.recipes.crafttweaker.CTRecipe;
import gregtech.api.recipes.crafttweaker.CTRecipeBuilder;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ValidationResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="mods.gregtech.recipe.RecipeMap")
@ZenRegister
public class RecipeMap<R extends RecipeBuilder<R>> {
    private static final List<RecipeMap<?>> RECIPE_MAPS = new ArrayList();
    @ZenProperty
    public static IChanceFunction chanceFunction = (chance, boostPerTier, tier) -> chance + boostPerTier * tier;
    public final String unlocalizedName;
    private final R recipeBuilderSample;
    private final int minInputs;
    private final int maxInputs;
    private final int minOutputs;
    private final int maxOutputs;
    private final int minFluidInputs;
    private final int maxFluidInputs;
    private final int minFluidOutputs;
    private final int maxFluidOutputs;
    private final TByteObjectMap<TextureArea> slotOverlays;
    protected TextureArea progressBarTexture;
    protected ProgressWidget.MoveType moveType;
    public final boolean isHidden;
    private final Map<FluidKey, Collection<Recipe>> recipeFluidMap = new HashMap<FluidKey, Collection<Recipe>>();
    private final Collection<Recipe> recipeList = new ArrayList<Recipe>();
    private static boolean foundInvalidRecipe = false;

    public RecipeMap(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, R defaultRecipe) {
        this(unlocalizedName, minInputs, maxInputs, minOutputs, maxOutputs, minFluidInputs, maxFluidInputs, minFluidOutputs, maxFluidOutputs, defaultRecipe, false);
    }

    public RecipeMap(String unlocalizedName, int minInputs, int maxInputs, int minOutputs, int maxOutputs, int minFluidInputs, int maxFluidInputs, int minFluidOutputs, int maxFluidOutputs, R defaultRecipe, boolean isHidden) {
        this.unlocalizedName = unlocalizedName;
        this.slotOverlays = new TByteObjectHashMap();
        this.progressBarTexture = GuiTextures.PROGRESS_BAR_ARROW;
        this.moveType = ProgressWidget.MoveType.HORIZONTAL;
        this.minInputs = minInputs;
        this.minFluidInputs = minFluidInputs;
        this.minOutputs = minOutputs;
        this.minFluidOutputs = minFluidOutputs;
        this.maxInputs = maxInputs;
        this.maxFluidInputs = maxFluidInputs;
        this.maxOutputs = maxOutputs;
        this.maxFluidOutputs = maxFluidOutputs;
        this.isHidden = isHidden;
        ((RecipeBuilder)defaultRecipe).setRecipeMap(this);
        this.recipeBuilderSample = defaultRecipe;
        RECIPE_MAPS.add(this);
    }

    @ZenMethod
    public static List<RecipeMap<?>> getRecipeMaps() {
        return Collections.unmodifiableList(RECIPE_MAPS);
    }

    @ZenMethod
    public static RecipeMap<?> getByName(String unlocalizedName) {
        return RECIPE_MAPS.stream().filter(map -> map.unlocalizedName.equals(unlocalizedName)).findFirst().orElse(null);
    }

    public static IChanceFunction getChanceFunction() {
        return chanceFunction;
    }

    public static boolean isFoundInvalidRecipe() {
        return foundInvalidRecipe;
    }

    public static void setFoundInvalidRecipe(boolean foundInvalidRecipe) {
        RecipeMap.foundInvalidRecipe |= foundInvalidRecipe;
        OrePrefix currentOrePrefix = OrePrefix.getCurrentProcessingPrefix();
        if (currentOrePrefix != null) {
            Material currentMaterial = OrePrefix.getCurrentMaterial();
            GTLog.logger.error("Error happened during processing ore registration of prefix {} and material {}. Seems like cross-mod compatibility issue. Report to GTCE github.", (Object)currentOrePrefix, (Object)currentMaterial);
        }
    }

    public RecipeMap<R> setProgressBar(TextureArea progressBar, ProgressWidget.MoveType moveType) {
        this.progressBarTexture = progressBar;
        this.moveType = moveType;
        return this;
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, TextureArea slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public RecipeMap<R> setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, TextureArea slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public boolean canInputFluidForce(Fluid fluid) {
        return false;
    }

    public Collection<Recipe> getRecipesForFluid(FluidStack fluid) {
        return this.recipeFluidMap.getOrDefault(new FluidKey(fluid), Collections.emptySet());
    }

    public void addRecipe(ValidationResult<Recipe> validationResult) {
        validationResult = this.postValidateRecipe(validationResult);
        switch (validationResult.getType()) {
            case SKIP: {
                return;
            }
            case INVALID: {
                RecipeMap.setFoundInvalidRecipe(true);
                return;
            }
        }
        Recipe recipe = validationResult.getResult();
        this.recipeList.add(recipe);
        for (FluidStack fluid : recipe.getFluidInputs()) {
            this.recipeFluidMap.computeIfAbsent(new FluidKey(fluid), k -> new HashSet(1)).add(recipe);
        }
    }

    public boolean removeRecipe(Recipe recipe) {
        if (this.recipeList.remove(recipe)) {
            this.recipeFluidMap.values().forEach(fluidMap -> fluidMap.removeIf(fluidRecipe -> fluidRecipe == recipe));
            return true;
        }
        return false;
    }

    protected ValidationResult<Recipe> postValidateRecipe(ValidationResult<Recipe> validationResult) {
        EnumValidationResult recipeStatus = validationResult.getType();
        Recipe recipe = validationResult.getResult();
        if (!GTUtility.isBetweenInclusive(this.getMinInputs(), this.getMaxInputs(), recipe.getInputs().size())) {
            GTLog.logger.error("Invalid amount of recipe inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getInputs().size(), (Object)this.getMinInputs(), (Object)this.getMaxInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinOutputs(), this.getMaxOutputs(), recipe.getOutputs().size() + recipe.getChancedOutputs().size())) {
            GTLog.logger.error("Invalid amount of recipe outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)(recipe.getOutputs().size() + recipe.getChancedOutputs().size()), (Object)this.getMinOutputs(), (Object)this.getMaxOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinFluidInputs(), this.getMaxFluidInputs(), recipe.getFluidInputs().size())) {
            GTLog.logger.error("Invalid amount of recipe fluid inputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getFluidInputs().size(), (Object)this.getMinFluidInputs(), (Object)this.getMaxFluidInputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            recipeStatus = EnumValidationResult.INVALID;
        }
        if (!GTUtility.isBetweenInclusive(this.getMinFluidOutputs(), this.getMaxFluidOutputs(), recipe.getFluidOutputs().size())) {
            GTLog.logger.error("Invalid amount of recipe fluid outputs. Actual: {}. Should be between {} and {} inclusive.", (Object)recipe.getFluidOutputs().size(), (Object)this.getMinFluidOutputs(), (Object)this.getMaxFluidOutputs());
            GTLog.logger.error("Stacktrace:", (Throwable)new IllegalArgumentException());
            recipeStatus = EnumValidationResult.INVALID;
        }
        return ValidationResult.newResult(recipeStatus, recipe);
    }

    @Nullable
    public Recipe findRecipe(long voltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs, int outputFluidTankCapacity) {
        return this.findRecipe(voltage, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs), outputFluidTankCapacity, MatchingMode.DEFAULT);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, int outputFluidTankCapacity) {
        return this.findRecipe(voltage, inputs, fluidInputs, outputFluidTankCapacity, MatchingMode.DEFAULT);
    }

    @Nullable
    public Recipe findRecipe(long voltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs, int outputFluidTankCapacity, MatchingMode matchingMode) {
        return this.findRecipe(voltage, GTUtility.itemHandlerToList(inputs), GTUtility.fluidHandlerToList(fluidInputs), outputFluidTankCapacity, matchingMode);
    }

    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, int outputFluidTankCapacity, MatchingMode matchingMode) {
        if (this.recipeList.isEmpty()) {
            return null;
        }
        if (this.minFluidInputs > 0 && GTUtility.amountOfNonNullElements(fluidInputs) < this.minFluidInputs) {
            return null;
        }
        if (this.minInputs > 0 && GTUtility.amountOfNonEmptyStacks(inputs) < this.minInputs) {
            return null;
        }
        if (this.maxInputs > 0) {
            return this.findByInputs(voltage, inputs, fluidInputs, matchingMode);
        }
        return this.findByFluidInputs(voltage, inputs, fluidInputs, matchingMode);
    }

    @Nullable
    private Recipe findByFluidInputs(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, MatchingMode matchingMode) {
        for (FluidStack fluid : fluidInputs) {
            Collection<Recipe> recipes;
            if (fluid == null || (recipes = this.recipeFluidMap.get(new FluidKey(fluid))) == null) continue;
            for (Recipe tmpRecipe : recipes) {
                if (!tmpRecipe.matches(false, inputs, fluidInputs, matchingMode)) continue;
                return voltage >= (long)tmpRecipe.getEUt() ? tmpRecipe : null;
            }
        }
        return null;
    }

    @Nullable
    private Recipe findByInputs(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, MatchingMode matchingMode) {
        for (Recipe recipe : this.recipeList) {
            if (!recipe.matches(false, inputs, fluidInputs, matchingMode)) continue;
            return voltage >= (long)recipe.getEUt() ? recipe : null;
        }
        return null;
    }

    public ModularUI.Builder createJeiUITemplate(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids) {
        return this.createUITemplate(() -> 0.0, importItems, exportItems, importFluids, exportFluids);
    }

    public ModularUI.Builder createUITemplate(DoubleSupplier progressSupplier, IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, FluidTankList importFluids, FluidTankList exportFluids) {
        ModularUI.Builder builder = ModularUI.defaultBuilder();
        builder.widget(new ProgressWidget(progressSupplier, 77, 22, 21, 20, this.progressBarTexture, this.moveType));
        this.addInventorySlotGroup(builder, importItems, importFluids, false);
        this.addInventorySlotGroup(builder, exportItems, exportFluids, true);
        return builder;
    }

    protected void addInventorySlotGroup(ModularUI.Builder builder, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isOutputs) {
        block7: {
            int i;
            int itemInputsCount = itemHandler.getSlots();
            int fluidInputsCount = fluidHandler.getTanks();
            boolean invertFluids = false;
            if (itemInputsCount == 0) {
                int tmp = itemInputsCount;
                itemInputsCount = fluidInputsCount;
                fluidInputsCount = tmp;
                invertFluids = true;
            }
            int[] inputSlotGrid = RecipeMap.determineSlotsGrid(itemInputsCount);
            int itemSlotsToLeft = inputSlotGrid[0];
            int itemSlotsToDown = inputSlotGrid[1];
            int startInputsX = isOutputs ? 106 : 69 - itemSlotsToLeft * 18;
            int startInputsY = 32 - (int)((double)itemSlotsToDown / 2.0 * 18.0);
            for (int i2 = 0; i2 < itemSlotsToDown; ++i2) {
                for (int j = 0; j < itemSlotsToLeft; ++j) {
                    int slotIndex = i2 * itemSlotsToLeft + j;
                    int x = startInputsX + 18 * j;
                    int y = startInputsY + 18 * i2;
                    this.addSlot(builder, x, y, slotIndex, itemHandler, fluidHandler, invertFluids, isOutputs);
                }
            }
            if (fluidInputsCount <= 0 && !invertFluids) break block7;
            if (itemSlotsToDown >= fluidInputsCount && itemSlotsToLeft < 3) {
                int startSpecX = isOutputs ? startInputsX + itemSlotsToLeft * 18 : startInputsX - 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int y = startInputsY + 18 * i;
                    this.addSlot(builder, startSpecX, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            } else {
                int startSpecY = startInputsY + itemSlotsToDown * 18;
                for (i = 0; i < fluidInputsCount; ++i) {
                    int x = isOutputs ? startInputsX + 18 * (i % 3) : startInputsX + itemSlotsToLeft * 18 - 18 - 18 * (i % 3);
                    int y = startSpecY + i / 3 * 18;
                    this.addSlot(builder, x, y, i, itemHandler, fluidHandler, !invertFluids, isOutputs);
                }
            }
        }
    }

    protected void addSlot(ModularUI.Builder builder, int x, int y, int slotIndex, IItemHandlerModifiable itemHandler, FluidTankList fluidHandler, boolean isFluid, boolean isOutputs) {
        if (!isFluid) {
            builder.widget(new SlotWidget((IItemHandler)itemHandler, slotIndex, x, y, true, !isOutputs).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, false, slotIndex == itemHandler.getSlots() - 1)));
        } else {
            builder.widget(new TankWidget(fluidHandler.getTankAt(slotIndex), x, y, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(this.getOverlaysForSlot(isOutputs, true, slotIndex == fluidHandler.getTanks() - 1)).setContainerClicking(true, !isOutputs));
        }
    }

    protected TextureArea[] getOverlaysForSlot(boolean isOutput, boolean isFluid, boolean isLast) {
        TextureArea base;
        TextureArea textureArea = base = isFluid ? GuiTextures.FLUID_SLOT : GuiTextures.SLOT;
        if (!isOutput && !isFluid && isLast && this.recipeBuilderSample instanceof IntCircuitRecipeBuilder) {
            return new TextureArea[]{base, GuiTextures.INT_CIRCUIT_OVERLAY};
        }
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new TextureArea[]{base, (TextureArea)this.slotOverlays.get(overlayKey)};
        }
        return new TextureArea[]{base};
    }

    protected static int[] determineSlotsGrid(int itemInputsCount) {
        int itemSlotsToLeft = 0;
        int itemSlotsToDown = 0;
        double sqrt = Math.sqrt(itemInputsCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemInputsCount % 3 == 0) {
            itemSlotsToDown = itemInputsCount / 3;
            itemSlotsToLeft = 3;
        } else if (itemInputsCount % 2 == 0) {
            itemSlotsToDown = itemInputsCount / 2;
            itemSlotsToLeft = 2;
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    public Collection<Recipe> getRecipeList() {
        return Collections.unmodifiableCollection(this.recipeList);
    }

    @ZenMethod(value="findRecipe")
    @Optional.Method(modid="crafttweaker")
    @Nullable
    public CTRecipe ctFindRecipe(long maxVoltage, IItemStack[] itemInputs, ILiquidStack[] fluidInputs, @Optional(valueLong=0x7FFFFFFFL) int outputFluidTankCapacity) {
        List<ItemStack> mcItemInputs = itemInputs == null ? Collections.emptyList() : Arrays.stream(itemInputs).map(CraftTweakerMC::getItemStack).collect(Collectors.toList());
        List<FluidStack> mcFluidInputs = fluidInputs == null ? Collections.emptyList() : Arrays.stream(fluidInputs).map(CraftTweakerMC::getLiquidStack).collect(Collectors.toList());
        Recipe backingRecipe = this.findRecipe(maxVoltage, mcItemInputs, mcFluidInputs, outputFluidTankCapacity);
        return backingRecipe == null ? null : new CTRecipe(this, backingRecipe);
    }

    @ZenGetter(value="recipes")
    @Optional.Method(modid="crafttweaker")
    public List<CTRecipe> ccGetRecipeList() {
        return this.getRecipeList().stream().map(recipe -> new CTRecipe(this, (Recipe)recipe)).collect(Collectors.toList());
    }

    @SideOnly(value=Side.CLIENT)
    @ZenGetter(value="localizedName")
    public String getLocalizedName() {
        return I18n.func_135052_a((String)("recipemap." + this.unlocalizedName + ".name"), (Object[])new Object[0]);
    }

    @ZenGetter(value="unlocalizedName")
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public R recipeBuilder() {
        return ((RecipeBuilder)this.recipeBuilderSample).copy();
    }

    @ZenMethod(value="recipeBuilder")
    @Optional.Method(modid="crafttweaker")
    public CTRecipeBuilder ctRecipeBuilder() {
        return new CTRecipeBuilder((RecipeBuilder<?>)this.recipeBuilder());
    }

    @ZenGetter(value="minInputs")
    public int getMinInputs() {
        return this.minInputs;
    }

    @ZenGetter(value="maxInputs")
    public int getMaxInputs() {
        return this.maxInputs;
    }

    @ZenGetter(value="minOutputs")
    public int getMinOutputs() {
        return this.minOutputs;
    }

    @ZenGetter(value="maxOutputs")
    public int getMaxOutputs() {
        return this.maxOutputs;
    }

    @ZenGetter(value="minFluidInputs")
    public int getMinFluidInputs() {
        return this.minFluidInputs;
    }

    @ZenGetter(value="maxFluidInputs")
    public int getMaxFluidInputs() {
        return this.maxFluidInputs;
    }

    @ZenGetter(value="minFluidOutputs")
    public int getMinFluidOutputs() {
        return this.minFluidOutputs;
    }

    @ZenGetter(value="maxFluidOutputs")
    public int getMaxFluidOutputs() {
        return this.maxFluidOutputs;
    }

    @ZenMethod
    public String toString() {
        return "RecipeMap{unlocalizedName='" + this.unlocalizedName + '\'' + '}';
    }

    @FunctionalInterface
    @ZenClass(value="mods.gregtech.recipe.IChanceFunction")
    @ZenRegister
    public static interface IChanceFunction {
        public int chanceFor(int var1, int var2, int var3);
    }
}

