/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class MonolithicPipeNet<NodeDataType>
extends PipeNet<NodeDataType> {
    protected NodeDataType nodeData;

    public MonolithicPipeNet(WorldPipeNet<NodeDataType, ? extends PipeNet> world) {
        super(world);
    }

    public NodeDataType getNodeData() {
        return this.nodeData;
    }

    @Override
    protected void addNode(BlockPos nodePos, Node<NodeDataType> node) {
        if (this.nodeData == null) {
            this.nodeData = node.data;
        } else if (!this.nodeData.equals(node.data)) {
            throw new IllegalArgumentException("Attempted to add node with different type to monolithic net!");
        }
        super.addNode(nodePos, node);
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<NodeDataType>> transferredNodes, PipeNet<NodeDataType> parentNet) {
        if (this.nodeData == null && !transferredNodes.isEmpty()) {
            this.nodeData = transferredNodes.values().iterator().next().data;
        }
        super.transferNodeData(transferredNodes, parentNet);
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.nodeData = this.getAllNodes().values().iterator().next().data;
    }

    @Override
    protected boolean areNodesCustomContactable(NodeDataType first, NodeDataType second, PipeNet<NodeDataType> secondNodeNet) {
        return this.nodeData == null || first.equals(this.nodeData) && second.equals(this.nodeData);
    }

    @Override
    protected boolean canAttachNode(NodeDataType nodeData) {
        return this.nodeData == null || nodeData.equals(this.nodeData);
    }
}

