/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multiblock;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class PatternMatchContext {
    private Map<String, Object> data = new HashMap<String, Object>();

    public void reset() {
        this.data.clear();
    }

    public void set(String key, Object value) {
        this.data.put(key, value);
    }

    public int getInt(String key) {
        return this.data.containsKey(key) ? (Integer)this.data.get(key) : 0;
    }

    public void increment(String key, int value) {
        this.set(key, this.getOrDefault(key, 0) + value);
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        return (T)this.data.getOrDefault(key, defaultValue);
    }

    public <T> T get(String key) {
        return (T)this.data.get(key);
    }

    public <T> T getOrCreate(String key, Supplier<T> creator) {
        T result = this.get(key);
        if (result == null) {
            result = creator.get();
            this.set(key, result);
        }
        return result;
    }

    public <T> T getOrPut(String key, T initialValue) {
        T result = this.get(key);
        if (result == null) {
            result = initialValue;
            this.set(key, result);
        }
        return result;
    }
}

