/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.block.BlockStateTileEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;

public abstract class SyncedTileEntityBase
extends BlockStateTileEntity {
    protected final List<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();

    public abstract void writeInitialSyncData(PacketBuffer var1);

    public abstract void receiveInitialSyncData(PacketBuffer var1);

    public abstract void receiveCustomData(int var1, PacketBuffer var2);

    public void writeCustomData(int discriminator, Consumer<PacketBuffer> dataWriter) {
        ByteBuf backedBuffer = Unpooled.buffer();
        dataWriter.accept(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        this.updateEntries.add(new UpdateEntry(discriminator, updateData));
        IBlockState blockState = this.func_145838_q().func_176203_a(this.func_145832_p());
        this.field_145850_b.func_184138_a(this.func_174877_v(), blockState, blockState, 0);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (UpdateEntry updateEntry : this.updateEntries) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.func_74768_a("i", updateEntry.discriminator);
            entryTag.func_74773_a("d", updateEntry.updateData);
            tagList.func_74742_a((NBTBase)entryTag);
        }
        this.updateEntries.clear();
        updateTag.func_74782_a("d", (NBTBase)tagList);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, updateTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTag = pkt.func_148857_g();
        NBTTagList tagList = updateTag.func_150295_c("d", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryTag = tagList.func_150305_b(i);
            int discriminator = entryTag.func_74762_e("i");
            byte[] updateData = entryTag.func_74770_j("d");
            ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
            this.receiveCustomData(discriminator, new PacketBuffer(backedBuffer));
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        ByteBuf backedBuffer = Unpooled.buffer();
        this.writeInitialSyncData(new PacketBuffer(backedBuffer));
        byte[] updateData = Arrays.copyOfRange(backedBuffer.array(), 0, backedBuffer.writerIndex());
        updateTag.func_74773_a("d", updateData);
        return updateTag;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.func_145839_a(tag);
        byte[] updateData = tag.func_74770_j("d");
        ByteBuf backedBuffer = Unpooled.copiedBuffer((byte[])updateData);
        this.receiveInitialSyncData(new PacketBuffer(backedBuffer));
    }

    private static class UpdateEntry {
        private final int discriminator;
        private final byte[] updateData;

        public UpdateEntry(int discriminator, byte[] updateData) {
            this.discriminator = discriminator;
            this.updateData = updateData;
        }
    }
}

