/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.MetaTileEntityUIFactory;
import gregtech.api.render.Textures;
import gregtech.api.util.GTFluidUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.InventoryUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class MetaTileEntity
implements ICoverable {
    public static final int DEFAULT_PAINTING_COLOR = 0xFFFFFF;
    public static final IndexedCuboid6 FULL_CUBE_COLLISION = new IndexedCuboid6(null, Cuboid6.full);
    public static final String TAG_KEY_PAINTING_COLOR = "PaintingColor";
    public static final String TAG_KEY_FRAGILE = "Fragile";
    public final ResourceLocation metaTileEntityId;
    MetaTileEntityHolder holder;
    protected IItemHandlerModifiable importItems;
    protected IItemHandlerModifiable exportItems;
    protected IItemHandler itemInventory;
    protected FluidTankList importFluids;
    protected FluidTankList exportFluids;
    protected IFluidHandler fluidInventory;
    protected List<MTETrait> mteTraits = new ArrayList<MTETrait>();
    protected EnumFacing frontFacing = EnumFacing.NORTH;
    protected int paintingColor = 0xFFFFFF;
    private final int[] sidedRedstoneOutput = new int[6];
    private final int[] sidedRedstoneInput = new int[6];
    private int cachedComparatorValue;
    private int cachedLightValue;
    protected boolean isFragile = false;
    private final CoverBehavior[] coverBehaviors = new CoverBehavior[6];
    @SideOnly(value=Side.CLIENT)
    protected ItemStack renderContextStack;

    public MetaTileEntity(ResourceLocation metaTileEntityId) {
        this.metaTileEntityId = metaTileEntityId;
        this.initializeInventory();
    }

    protected void initializeInventory() {
        this.importItems = this.createImportItemHandler();
        this.exportItems = this.createExportItemHandler();
        this.itemInventory = new ItemHandlerProxy((IItemHandler)this.importItems, (IItemHandler)this.exportItems);
        this.importFluids = this.createImportFluidHandler();
        this.exportFluids = this.createExportFluidHandler();
        this.fluidInventory = new FluidHandlerProxy(this.importFluids, this.exportFluids);
    }

    public MetaTileEntityHolder getHolder() {
        return this.holder;
    }

    public abstract MetaTileEntity createMetaTileEntity(MetaTileEntityHolder var1);

    @Override
    public World getWorld() {
        return this.holder == null ? null : this.holder.func_145831_w();
    }

    @Override
    public BlockPos getPos() {
        return this.holder == null ? null : this.holder.func_174877_v();
    }

    @Override
    public void markDirty() {
        if (this.holder != null) {
            this.holder.func_70296_d();
        }
    }

    @Override
    @Deprecated
    public long getTimer() {
        return this.holder == null ? 0L : this.holder.getTimer();
    }

    @Override
    public long getOffsetTimer() {
        return this.holder == null ? 0L : this.holder.getOffsetTimer();
    }

    public void writeCustomData(int discriminator, Consumer<PacketBuffer> dataWriter) {
        if (this.holder != null) {
            this.holder.writeCustomData(discriminator, dataWriter);
        }
    }

    public void addDebugInfo(List<String> list) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
    }

    @SideOnly(value=Side.CLIENT)
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderContextStack(ItemStack itemStack) {
        this.renderContextStack = itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        TextureAtlasSprite atlasSprite = TextureUtils.getMissingSprite();
        IVertexOperation[] renderPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering())));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, renderPipeline, face, Cuboid6.full, atlasSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(BlockRenderLayer renderLayer) {
        return renderLayer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPaintingColorForRendering() {
        NBTTagCompound tagCompound;
        if (this.getWorld() == null && this.renderContextStack != null && (tagCompound = this.renderContextStack.func_77978_p()) != null && tagCompound.func_150297_b(TAG_KEY_PAINTING_COLOR, 3)) {
            return tagCompound.func_74762_e(TAG_KEY_PAINTING_COLOR);
        }
        return this.paintingColor;
    }

    public void initFromItemStackData(NBTTagCompound itemStack) {
        if (itemStack.func_150297_b(TAG_KEY_PAINTING_COLOR, 3)) {
            this.setPaintingColor(itemStack.func_74762_e(TAG_KEY_PAINTING_COLOR));
        }
        if (itemStack.func_74764_b(TAG_KEY_FRAGILE)) {
            this.setFragile(itemStack.func_74767_n(TAG_KEY_FRAGILE));
        }
    }

    public void writeItemStackData(NBTTagCompound itemStack) {
        if (this.paintingColor != 0xFFFFFF) {
            itemStack.func_74768_a(TAG_KEY_PAINTING_COLOR, this.paintingColor);
        }
    }

    public void getSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> subItems) {
        subItems.add((Object)this.getStackForm());
    }

    public String getItemSubTypeId(ItemStack itemStack) {
        return "";
    }

    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return null;
    }

    public final String getMetaName() {
        return String.format("%s.machine.%s", this.metaTileEntityId.func_110624_b(), this.metaTileEntityId.func_110623_a());
    }

    public final String getMetaFullName() {
        return this.getMetaName() + ".name";
    }

    void addMetaTileEntityTrait(MTETrait trait) {
        this.mteTraits.removeIf(otherTrait -> {
            if (trait.getName().equals(otherTrait.getName())) {
                return true;
            }
            if (otherTrait.getNetworkID() == trait.getNetworkID()) {
                String message = "Trait %s is incompatible with trait %s, as they both use same network id %d";
                throw new IllegalArgumentException(String.format(message, trait, otherTrait, trait.getNetworkID()));
            }
            return false;
        });
        this.mteTraits.add(trait);
    }

    protected IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(0);
    }

    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(0);
    }

    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[0]);
    }

    protected boolean openGUIOnRightClick() {
        return true;
    }

    protected abstract ModularUI createUI(EntityPlayer var1);

    public final void onCoverLeftClick(EntityPlayer playerIn, CuboidRayTraceResult result) {
        CoverBehavior coverBehavior = this.getCoverAtSide(result.field_178784_b);
        if (coverBehavior == null || !coverBehavior.onLeftClick(playerIn, result)) {
            this.onLeftClick(playerIn, result.field_178784_b, result);
        }
    }

    public final boolean onCoverRightClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult result) {
        EnumActionResult coverResult;
        CoverBehavior coverBehavior = this.getCoverAtSide(result.field_178784_b);
        EnumActionResult enumActionResult = coverResult = coverBehavior == null ? EnumActionResult.PASS : coverBehavior.onRightClick(playerIn, hand, result);
        if (coverResult != EnumActionResult.PASS) {
            return coverResult == EnumActionResult.SUCCESS;
        }
        return this.onRightClick(playerIn, hand, result.field_178784_b, result);
    }

    public final boolean onCoverScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult result) {
        EnumActionResult coverResult;
        EnumFacing coverSide;
        CoverBehavior coverBehavior;
        EnumFacing hitFacing = ICoverable.determineGridSideHit((RayTraceResult)result);
        boolean accessingActiveOutputSide = false;
        if (this.getCapability(GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE, hitFacing) != null) {
            accessingActiveOutputSide = playerIn.func_70093_af();
        }
        CoverBehavior coverBehavior2 = coverBehavior = (coverSide = ICoverable.traceCoverSide((RayTraceResult)result)) == null ? null : this.getCoverAtSide(coverSide);
        EnumActionResult enumActionResult = coverBehavior == null ? EnumActionResult.PASS : (coverResult = accessingActiveOutputSide ? EnumActionResult.PASS : coverBehavior.onScrewdriverClick(playerIn, hand, result));
        if (coverResult != EnumActionResult.PASS) {
            return coverResult == EnumActionResult.SUCCESS;
        }
        return this.onScrewdriverClick(playerIn, hand, result.field_178784_b, result);
    }

    public boolean onRightClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af() && this.openGUIOnRightClick()) {
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                MetaTileEntityUIFactory.INSTANCE.openUI(this.getHolder(), (EntityPlayerMP)playerIn);
            }
            return true;
        }
        return false;
    }

    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        if (playerIn.func_70093_af()) {
            if (wrenchSide == this.getFrontFacing() || !this.isValidFrontFacing(wrenchSide) || !this.hasFrontFacing()) {
                return false;
            }
            if (wrenchSide != null && !this.getWorld().field_72995_K) {
                this.setFrontFacing(wrenchSide);
            }
            return true;
        }
        return false;
    }

    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        return false;
    }

    public void onLeftClick(EntityPlayer player, EnumFacing facing, CuboidRayTraceResult hitResult) {
    }

    @Override
    @Nullable
    public final CoverBehavior getCoverAtSide(EnumFacing side) {
        return this.coverBehaviors[side.func_176745_a()];
    }

    @Override
    public boolean placeCoverOnSide(EnumFacing side, ItemStack itemStack, CoverDefinition coverDefinition) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        Preconditions.checkNotNull((Object)((Object)coverDefinition), (Object)"coverDefinition");
        CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, side);
        if (!this.canPlaceCoverOnSide(side) || !coverBehavior.canAttach()) {
            return false;
        }
        if (this.coverBehaviors[side.func_176745_a()] != null) {
            this.removeCover(side);
        }
        this.coverBehaviors[side.func_176745_a()] = coverBehavior;
        coverBehavior.onAttached(itemStack);
        this.writeCustomData(-5, buffer -> {
            buffer.writeByte(side.func_176745_a());
            buffer.func_150787_b(CoverDefinition.getNetworkIdForCover(coverDefinition));
            coverBehavior.writeInitialSyncData((PacketBuffer)buffer);
        });
        if (this.getHolder() != null) {
            this.getHolder().notifyBlockUpdate();
            this.getHolder().func_70296_d();
        }
        this.onCoverPlacementUpdate();
        return true;
    }

    @Override
    public final boolean removeCover(EnumFacing side) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return false;
        }
        List<ItemStack> drops = coverBehavior.getDrops();
        coverBehavior.onRemoved();
        this.coverBehaviors[side.func_176745_a()] = null;
        for (ItemStack dropStack : drops) {
            Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
        }
        this.writeCustomData(-6, buffer -> buffer.writeByte(side.func_176745_a()));
        if (this.getHolder() != null) {
            this.getHolder().notifyBlockUpdate();
            this.getHolder().func_70296_d();
        }
        this.onCoverPlacementUpdate();
        return true;
    }

    protected void onCoverPlacementUpdate() {
    }

    public final void dropAllCovers() {
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (coverBehavior == null) continue;
            List<ItemStack> drops = coverBehavior.getDrops();
            coverBehavior.onRemoved();
            for (ItemStack dropStack : drops) {
                Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)dropStack);
            }
        }
    }

    @Override
    public boolean canPlaceCoverOnSide(EnumFacing side) {
        if (this.hasFrontFacing() && side == this.getFrontFacing()) {
            return false;
        }
        ArrayList<IndexedCuboid6> collisionList = new ArrayList<IndexedCuboid6>();
        this.addCollisionBoundingBox(collisionList);
        return !ICoverable.doesCoverCollide(side, collisionList, this.getCoverPlateThickness());
    }

    @Override
    public double getCoverPlateThickness() {
        return 0.0;
    }

    @Override
    public boolean shouldRenderBackSide() {
        return !this.isOpaqueCube();
    }

    public void onLoad() {
        this.cachedComparatorValue = this.getActualComparatorValue();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.sidedRedstoneInput[side.func_176745_a()] = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
        }
    }

    public void onUnload() {
    }

    public final boolean canConnectRedstone(@Nullable EnumFacing side) {
        if (side == null) {
            return this.canConnectRedstone(EnumFacing.UP) || this.canConnectRedstone(EnumFacing.DOWN);
        }
        CoverBehavior coverBehavior = this.getCoverAtSide(side);
        if (coverBehavior == null) {
            return this.canMachineConnectRedstone(side);
        }
        return coverBehavior.canConnectRedstone();
    }

    protected boolean canMachineConnectRedstone(EnumFacing side) {
        return false;
    }

    @Override
    public final int getInputRedstoneSignal(EnumFacing side, boolean ignoreCover) {
        if (!ignoreCover && this.getCoverAtSide(side) != null) {
            return 0;
        }
        return this.sidedRedstoneInput[side.func_176745_a()];
    }

    public final boolean isBlockRedstonePowered() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getInputRedstoneSignal(side, false) <= 0) continue;
            return true;
        }
        return false;
    }

    public void onNeighborChanged() {
    }

    public void updateInputRedstoneSignals() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int currentValue;
            int redstoneValue = GTUtility.getRedstonePower(this.getWorld(), this.getPos(), side);
            if (redstoneValue == (currentValue = this.sidedRedstoneInput[side.func_176745_a()])) continue;
            this.sidedRedstoneInput[side.func_176745_a()] = redstoneValue;
            CoverBehavior coverBehavior = this.getCoverAtSide(side);
            if (coverBehavior == null) continue;
            coverBehavior.onRedstoneInputSignalChange(redstoneValue);
        }
    }

    public int getActualComparatorValue() {
        return 0;
    }

    public int getActualLightValue() {
        return 0;
    }

    public final int getComparatorValue() {
        return this.cachedComparatorValue;
    }

    public final int getLightValue() {
        return this.cachedLightValue;
    }

    private void updateComparatorValue() {
        int newComparatorValue = this.getActualComparatorValue();
        if (this.cachedComparatorValue != newComparatorValue) {
            this.cachedComparatorValue = newComparatorValue;
            if (this.getWorld() != null && !this.getWorld().field_72995_K) {
                this.notifyBlockUpdate();
            }
        }
    }

    private void updateLightValue() {
        int newLightValue = this.getActualLightValue();
        if (this.cachedLightValue != newLightValue) {
            this.cachedLightValue = newLightValue;
            if (this.getWorld() != null) {
                this.getWorld().func_175664_x(this.getPos());
            }
        }
    }

    public void update() {
        for (MTETrait mteTrait : this.mteTraits) {
            if (!this.shouldUpdate(mteTrait)) continue;
            mteTrait.update();
        }
        if (!this.getWorld().field_72995_K) {
            for (CoverBehavior coverBehavior : this.coverBehaviors) {
                if (!(coverBehavior instanceof ITickable)) continue;
                ((ITickable)coverBehavior).func_73660_a();
            }
            if (this.getOffsetTimer() % 5L == 0L) {
                this.updateComparatorValue();
            }
        }
        if (this.getOffsetTimer() % 5L == 0L) {
            this.updateLightValue();
        }
    }

    protected boolean shouldUpdate(MTETrait trait) {
        return true;
    }

    public final ItemStack getStackForm(int amount) {
        int metaTileEntityIntId = GregTechAPI.META_TILE_ENTITY_REGISTRY.getIdByObjectName(this.metaTileEntityId);
        return new ItemStack((Block)GregTechAPI.MACHINE, amount, metaTileEntityIntId);
    }

    @Override
    public final ItemStack getStackForm() {
        return this.getStackForm(1);
    }

    public void getDrops(NonNullList<ItemStack> dropsList, @Nullable EntityPlayer harvester) {
    }

    public ItemStack getPickItem(CuboidRayTraceResult result, EntityPlayer player) {
        IndexedCuboid6 hitCuboid = result.cuboid6;
        if (hitCuboid.data instanceof ICoverable.CoverSideData) {
            ICoverable.CoverSideData coverSideData = (ICoverable.CoverSideData)hitCuboid.data;
            CoverBehavior behavior = this.getCoverAtSide(coverSideData.side);
            return behavior == null ? ItemStack.field_190927_a : behavior.getPickItem();
        }
        if (hitCuboid.data == null || hitCuboid.data instanceof ICoverable.PrimaryBoxData) {
            CoverBehavior behavior = this.getCoverAtSide(result.field_178784_b);
            if (behavior != null) {
                return behavior.getPickItem();
            }
            return this.getStackForm();
        }
        return ItemStack.field_190927_a;
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public int getLightOpacity() {
        return 255;
    }

    public void addCollisionBoundingBox(List<IndexedCuboid6> collisionList) {
        collisionList.add(FULL_CUBE_COLLISION);
    }

    public BlockFaceShape getFaceShape(EnumFacing side) {
        return this.isOpaqueCube() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public String getHarvestTool() {
        return "wrench";
    }

    public int getHarvestLevel() {
        return 1;
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        buf.writeByte(this.frontFacing.func_176745_a());
        buf.writeInt(this.paintingColor);
        buf.writeShort(this.mteTraits.size());
        for (MTETrait trait : this.mteTraits) {
            buf.func_150787_b(trait.getNetworkID());
            trait.writeInitialData(buf);
        }
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.getCoverAtSide(coverSide);
            if (coverBehavior != null) {
                int coverId = CoverDefinition.getNetworkIdForCover(coverBehavior.getCoverDefinition());
                buf.func_150787_b(coverId);
                coverBehavior.writeInitialSyncData(buf);
                continue;
            }
            buf.func_150787_b(-1);
        }
        buf.writeBoolean(this.isFragile);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.paintingColor = buf.readInt();
        int amountOfTraits = buf.readShort();
        for (int i = 0; i < amountOfTraits; ++i) {
            int traitNetworkId = buf.func_150792_a();
            MTETrait trait = this.mteTraits.stream().filter(otherTrait -> otherTrait.getNetworkID() == traitNetworkId).findAny().get();
            trait.receiveInitialData(buf);
        }
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            int coverId = buf.func_150792_a();
            if (coverId == -1) continue;
            CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(coverId);
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, coverSide);
            coverBehavior.readInitialSyncData(buf);
            this.coverBehaviors[coverSide.func_176745_a()] = coverBehavior;
        }
        this.isFragile = buf.readBoolean();
    }

    public void writeTraitData(MTETrait trait, int internalId, Consumer<PacketBuffer> dataWriter) {
        this.writeCustomData(-4, buffer -> {
            buffer.func_150787_b(trait.getNetworkID());
            buffer.func_150787_b(internalId);
            dataWriter.accept((PacketBuffer)buffer);
        });
    }

    @Override
    public void writeCoverData(CoverBehavior cover, int internalId, Consumer<PacketBuffer> dataWriter) {
        this.writeCustomData(-7, buffer -> {
            buffer.writeByte(cover.attachedSide.func_176745_a());
            buffer.func_150787_b(internalId);
            dataWriter.accept((PacketBuffer)buffer);
        });
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        if (dataId == -2) {
            this.frontFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == -3) {
            this.paintingColor = buf.readInt();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == -4) {
            int traitNetworkId = buf.func_150792_a();
            MTETrait trait = this.mteTraits.stream().filter(otherTrait -> otherTrait.getNetworkID() == traitNetworkId).findAny().get();
            int internalId = buf.func_150792_a();
            trait.receiveCustomData(internalId, buf);
        } else if (dataId == -5) {
            CoverBehavior coverBehavior;
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            int coverId = buf.func_150792_a();
            CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(coverId);
            this.coverBehaviors[placementSide.func_176745_a()] = coverBehavior = coverDefinition.createCoverBehavior(this, placementSide);
            coverBehavior.readInitialSyncData(buf);
            this.onCoverPlacementUpdate();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == -6) {
            EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
            this.coverBehaviors[placementSide.func_176745_a()] = null;
            this.onCoverPlacementUpdate();
            this.getHolder().scheduleChunkForRenderUpdate();
        } else if (dataId == -7) {
            EnumFacing coverSide = EnumFacing.field_82609_l[buf.readByte()];
            CoverBehavior coverBehavior = this.getCoverAtSide(coverSide);
            int internalId = buf.func_150792_a();
            if (coverBehavior != null) {
                coverBehavior.readUpdateData(internalId, buf);
            }
        } else if (dataId == -8) {
            this.isFragile = buf.readBoolean();
            this.getHolder().scheduleChunkForRenderUpdate();
        }
    }

    public BlockFaceShape getCoverFaceShape(EnumFacing side) {
        if (this.getCoverAtSide(side) != null) {
            return BlockFaceShape.SOLID;
        }
        return this.getFaceShape(side);
    }

    public final <T> T getCoverCapability(Capability<T> capability, EnumFacing side) {
        boolean isCoverable = capability == GregtechTileCapabilities.CAPABILITY_COVERABLE;
        CoverBehavior coverBehavior = side == null ? null : this.getCoverAtSide(side);
        T originalCapability = this.getCapability(capability, side);
        if (coverBehavior != null && !isCoverable) {
            return coverBehavior.getCapability(capability, originalCapability);
        }
        return originalCapability;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        IEnergyContainer energyContainer;
        MTETrait mteTrait;
        if (capability == GregtechTileCapabilities.CAPABILITY_COVERABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_COVERABLE.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.getFluidInventory().getTankProperties().length > 0) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.getFluidInventory());
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getItemInventory().getSlots() > 0) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemInventory());
        }
        T capabilityResult = null;
        Iterator<MTETrait> iterator = this.mteTraits.iterator();
        while (iterator.hasNext() && (capabilityResult = (T)(mteTrait = iterator.next()).getCapability(capability)) == null) {
        }
        if (side != null && capabilityResult instanceof IEnergyContainer && !(energyContainer = (IEnergyContainer)capabilityResult).inputsEnergy(side) && !energyContainer.outputsEnergy(side)) {
            return null;
        }
        return capabilityResult;
    }

    public boolean fillInternalTankFromFluidContainer(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, int inputSlot, int outputSlot) {
        ItemStack inputContainerStack = importItems.extractItem(inputSlot, 1, true);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)this.importFluids, (int)Integer.MAX_VALUE, null, (boolean)false);
        if (result.isSuccess()) {
            ItemStack remainingItem = result.getResult();
            if (ItemStack.func_77989_b((ItemStack)inputContainerStack, (ItemStack)remainingItem)) {
                return false;
            }
            if (!remainingItem.func_190926_b() && !exportItems.insertItem(outputSlot, remainingItem, true).func_190926_b()) {
                return false;
            }
            FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)this.importFluids, (int)Integer.MAX_VALUE, null, (boolean)true);
            importItems.extractItem(inputSlot, 1, false);
            exportItems.insertItem(outputSlot, remainingItem, false);
            return true;
        }
        return false;
    }

    public boolean fillContainerFromInternalTank(IItemHandlerModifiable importItems, IItemHandlerModifiable exportItems, int inputSlot, int outputSlot) {
        ItemStack emptyContainer = importItems.extractItem(inputSlot, 1, true);
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)this.exportFluids, (int)Integer.MAX_VALUE, null, (boolean)false);
        if (result.isSuccess()) {
            ItemStack remainingItem = result.getResult();
            if (!remainingItem.func_190926_b() && !exportItems.insertItem(outputSlot, remainingItem, true).func_190926_b()) {
                return false;
            }
            FluidUtil.tryFillContainer((ItemStack)emptyContainer, (IFluidHandler)this.exportFluids, (int)Integer.MAX_VALUE, null, (boolean)true);
            importItems.extractItem(inputSlot, 1, false);
            exportItems.insertItem(outputSlot, remainingItem, false);
            return true;
        }
        return false;
    }

    public void pushFluidsIntoNearbyHandlers(EnumFacing ... allowedFaces) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing nearbyFacing : allowedFaces) {
            blockPos.func_189533_g((Vec3i)this.getPos()).func_189536_c(nearbyFacing);
            TileEntity tileEntity = this.getWorld().func_175625_s((BlockPos)blockPos);
            if (tileEntity == null) continue;
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, nearbyFacing.func_176734_d());
            IFluidHandler myFluidHandler = (IFluidHandler)this.getCoverCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, nearbyFacing);
            if (fluidHandler == null || myFluidHandler == null) continue;
            GTFluidUtils.transferFluids(myFluidHandler, fluidHandler, Integer.MAX_VALUE);
        }
        blockPos.func_185344_t();
    }

    public void pullFluidsFromNearbyHandlers(EnumFacing ... allowedFaces) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing nearbyFacing : allowedFaces) {
            blockPos.func_189533_g((Vec3i)this.getPos()).func_189536_c(nearbyFacing);
            TileEntity tileEntity = this.getWorld().func_175625_s((BlockPos)blockPos);
            if (tileEntity == null) continue;
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, nearbyFacing.func_176734_d());
            IFluidHandler myFluidHandler = (IFluidHandler)this.getCoverCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, nearbyFacing);
            if (fluidHandler == null || myFluidHandler == null) continue;
            GTFluidUtils.transferFluids(fluidHandler, myFluidHandler, Integer.MAX_VALUE);
        }
        blockPos.func_185344_t();
    }

    public void pushItemsIntoNearbyHandlers(EnumFacing ... allowedFaces) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing nearbyFacing : allowedFaces) {
            blockPos.func_189533_g((Vec3i)this.getPos()).func_189536_c(nearbyFacing);
            TileEntity tileEntity = this.getWorld().func_175625_s((BlockPos)blockPos);
            if (tileEntity == null) continue;
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, nearbyFacing.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)this.getCoverCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, nearbyFacing);
            if (itemHandler == null || myItemHandler == null) continue;
            MetaTileEntity.moveInventoryItems(myItemHandler, itemHandler);
        }
        blockPos.func_185344_t();
    }

    public void pullItemsFromNearbyHandlers(EnumFacing ... allowedFaces) {
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing nearbyFacing : allowedFaces) {
            blockPos.func_189533_g((Vec3i)this.getPos()).func_189536_c(nearbyFacing);
            TileEntity tileEntity = this.getWorld().func_175625_s((BlockPos)blockPos);
            if (tileEntity == null) continue;
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, nearbyFacing.func_176734_d());
            IItemHandler myItemHandler = (IItemHandler)this.getCoverCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, nearbyFacing);
            if (itemHandler == null || myItemHandler == null) continue;
            MetaTileEntity.moveInventoryItems(itemHandler, myItemHandler);
        }
        blockPos.func_185344_t();
    }

    protected static void moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.func_190926_b()) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)sourceStack, (boolean)false);
        }
    }

    public static boolean addItemsToItemHandler(IItemHandler handler, boolean simulate, List<ItemStack> items) {
        boolean canMerge = InventoryUtils.simulateItemStackMerge(items, handler);
        if (!simulate && canMerge) {
            items.forEach(stack -> {
                ItemStack rest = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
                if (!rest.func_190926_b()) {
                    throw new IllegalStateException(String.format("Insertion failed, remaining stack contained %d items.", rest.func_190916_E()));
                }
            });
        }
        return canMerge;
    }

    public static boolean addFluidsToFluidHandler(IFluidHandler handler, boolean simulate, List<FluidStack> items) {
        boolean filledAll = true;
        for (FluidStack stack : items) {
            int filled = handler.fill(stack, !simulate);
            if ((filledAll &= filled == stack.amount) || !simulate) continue;
            return false;
        }
        return filledAll;
    }

    public final int getOutputRedstoneSignal(@Nullable EnumFacing side) {
        if (side == null) {
            return this.getHighestOutputRedstoneSignal();
        }
        CoverBehavior behavior = this.getCoverAtSide(side);
        int sidedOutput = this.sidedRedstoneOutput[side.func_176745_a()];
        return behavior == null ? sidedOutput : behavior.getRedstoneSignalOutput();
    }

    public final int getHighestOutputRedstoneSignal() {
        int highestSignal = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            CoverBehavior behavior = this.getCoverAtSide(side);
            int sidedOutput = this.sidedRedstoneOutput[side.func_176745_a()];
            int sideResult = behavior == null ? sidedOutput : behavior.getRedstoneSignalOutput();
            highestSignal = Math.max(highestSignal, sideResult);
        }
        return highestSignal;
    }

    public final void setOutputRedstoneSignal(EnumFacing side, int strength) {
        Preconditions.checkNotNull((Object)side, (Object)"side");
        this.sidedRedstoneOutput[side.func_176745_a()] = strength;
        if (this.getWorld() != null && !this.getWorld().field_72995_K && this.getCoverAtSide(side) == null) {
            this.notifyBlockUpdate();
            this.markDirty();
        }
    }

    @Override
    public void notifyBlockUpdate() {
        this.getHolder().notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.getHolder().scheduleChunkForRenderUpdate();
    }

    public void setFrontFacing(EnumFacing frontFacing) {
        Preconditions.checkNotNull((Object)frontFacing, (Object)"frontFacing");
        this.frontFacing = frontFacing;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.getHolder().notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(-2, buf -> buf.writeByte(frontFacing.func_176745_a()));
            this.mteTraits.forEach(trait -> trait.onFrontFacingSet(frontFacing));
        }
    }

    public void setPaintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.getHolder().notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(-3, buf -> buf.writeInt(paintingColor));
        }
    }

    public void setFragile(boolean fragile) {
        this.isFragile = fragile;
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.getHolder().notifyBlockUpdate();
            this.markDirty();
            this.writeCustomData(-8, buf -> buf.writeBoolean(fragile));
        }
    }

    public boolean isValidFrontFacing(EnumFacing facing) {
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN;
    }

    public boolean hasFrontFacing() {
        return true;
    }

    protected boolean shouldSerializeInventories() {
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data.func_74768_a("FrontFacing", this.frontFacing.func_176745_a());
        data.func_74768_a(TAG_KEY_PAINTING_COLOR, this.paintingColor);
        data.func_74768_a("CachedLightValue", this.cachedLightValue);
        if (this.shouldSerializeInventories()) {
            GTUtility.writeItems((IItemHandler)this.importItems, "ImportInventory", data);
            GTUtility.writeItems((IItemHandler)this.exportItems, "ExportInventory", data);
            data.func_74782_a("ImportFluidInventory", (NBTBase)this.importFluids.serializeNBT());
            data.func_74782_a("ExportFluidInventory", (NBTBase)this.exportFluids.serializeNBT());
        }
        for (MTETrait mteTrait : this.mteTraits) {
            data.func_74782_a(mteTrait.getName(), (NBTBase)mteTrait.serializeNBT());
        }
        NBTTagList coversList = new NBTTagList();
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            CoverBehavior coverBehavior = this.coverBehaviors[coverSide.func_176745_a()];
            if (coverBehavior == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            ResourceLocation coverId = coverBehavior.getCoverDefinition().getCoverId();
            tagCompound.func_74778_a("CoverId", coverId.toString());
            tagCompound.func_74774_a("Side", (byte)coverSide.func_176745_a());
            coverBehavior.writeToNBT(tagCompound);
            coversList.func_74742_a((NBTBase)tagCompound);
        }
        data.func_74782_a("Covers", (NBTBase)coversList);
        data.func_74757_a(TAG_KEY_FRAGILE, this.isFragile);
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        this.frontFacing = EnumFacing.field_82609_l[data.func_74762_e("FrontFacing")];
        this.paintingColor = data.func_74762_e(TAG_KEY_PAINTING_COLOR);
        this.cachedLightValue = data.func_74762_e("CachedLightValue");
        if (this.shouldSerializeInventories()) {
            GTUtility.readItems(this.importItems, "ImportInventory", data);
            GTUtility.readItems(this.exportItems, "ExportInventory", data);
            this.importFluids.deserializeNBT(data.func_74775_l("ImportFluidInventory"));
            this.exportFluids.deserializeNBT(data.func_74775_l("ExportFluidInventory"));
        }
        for (MTETrait mteTrait : this.mteTraits) {
            NBTTagCompound traitCompound = data.func_74775_l(mteTrait.getName());
            mteTrait.deserializeNBT(traitCompound);
        }
        NBTTagList coversList = data.func_150295_c("Covers", 10);
        for (int index = 0; index < coversList.func_74745_c(); ++index) {
            NBTTagCompound tagCompound = coversList.func_150305_b(index);
            if (!tagCompound.func_150297_b("CoverId", 8)) continue;
            EnumFacing coverSide = EnumFacing.field_82609_l[tagCompound.func_74771_c("Side")];
            ResourceLocation coverId = new ResourceLocation(tagCompound.func_74779_i("CoverId"));
            CoverDefinition coverDefinition = CoverDefinition.getCoverById(coverId);
            CoverBehavior coverBehavior = coverDefinition.createCoverBehavior(this, coverSide);
            coverBehavior.readFromNBT(tagCompound);
            this.coverBehaviors[coverSide.func_176745_a()] = coverBehavior;
        }
        this.isFragile = data.func_74767_n(TAG_KEY_FRAGILE);
    }

    @Override
    public boolean isValid() {
        return this.getHolder() != null && this.getHolder().isValid();
    }

    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        MetaTileEntity.clearInventory(itemBuffer, this.importItems);
        MetaTileEntity.clearInventory(itemBuffer, this.exportItems);
    }

    public static void clearInventory(NonNullList<ItemStack> itemBuffer, IItemHandlerModifiable inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.func_190926_b()) continue;
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
            itemBuffer.add((Object)stackInSlot);
        }
    }

    public void onAttached() {
    }

    public void onRemoval() {
    }

    public EnumFacing getFrontFacing() {
        return this.frontFacing;
    }

    @Override
    public int getPaintingColor() {
        return this.paintingColor;
    }

    public IItemHandler getItemInventory() {
        return this.itemInventory;
    }

    public IFluidHandler getFluidInventory() {
        return this.fluidInventory;
    }

    public IItemHandlerModifiable getImportItems() {
        return this.importItems;
    }

    public IItemHandlerModifiable getExportItems() {
        return this.exportItems;
    }

    public FluidTankList getImportFluids() {
        return this.importFluids;
    }

    public FluidTankList getExportFluids() {
        return this.exportFluids;
    }

    public boolean isFragile() {
        return this.isFragile;
    }

    public boolean shouldDropWhenDestroyed() {
        return !this.isFragile();
    }

    public float getBlockHardness() {
        return 6.0f;
    }

    public float getBlockResistance() {
        return 6.0f;
    }

    public boolean keepsInventory() {
        return false;
    }
}

