/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets.armor;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.armor.ConnectionType;
import gregtech.api.gui.widgets.armor.ElementOrientation;
import gregtech.api.gui.widgets.armor.GridConnection;
import gregtech.api.gui.widgets.armor.GridElementWidget;
import gregtech.api.util.Position;
import gregtech.api.util.PositionedRect;
import gregtech.api.util.Size;
import java.util.ArrayList;
import java.util.List;

public class SimpleGridElementWidget
extends GridElementWidget {
    private final TextureArea backgroundTexture;
    private final PositionedRect elementRect;
    private List<GridConnection> gridConnections = new ArrayList<GridConnection>();

    public SimpleGridElementWidget(Size elementSize, int slotSize, TextureArea backgroundTexture, PositionedRect elementRect) {
        super(elementSize, slotSize);
        this.backgroundTexture = backgroundTexture;
        this.elementRect = elementRect;
    }

    public void addConnection(int cellIndex, ConnectionType connectionType, ElementOrientation side) {
        GridConnection connection = new GridConnection(connectionType, this.slotSize, this.initialElementSize, this.elementRect, side, cellIndex);
        this.gridConnections.add(connection);
    }

    public List<GridConnection> getGridConnections() {
        return this.gridConnections;
    }

    @Override
    public boolean canConnect(ElementOrientation side, Position relativeSlotPos, ConnectionType connectionType) {
        Position relativePos = new Position(relativeSlotPos.x * this.slotSize, relativeSlotPos.y * this.slotSize);
        for (GridConnection gridConnection : this.gridConnections) {
            Position position = gridConnection.getSelfPosition();
            if (!SimpleGridElementWidget.isMouseOver(relativePos.x, relativePos.y, this.slotSize, this.slotSize, position.x, position.y) || gridConnection.getOrientation() != side || gridConnection.getConnectionType() != connectionType) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void onPositionUpdate() {
        super.onPositionUpdate();
        this.gridConnections.forEach(it -> it.setParentPosition(this.getPosition()));
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, context);
        this.backgroundTexture.drawRotated(this.getPosition().x, this.getPosition().y, this.initialElementSize, this.elementRect, this.orientation.rotationValue);
        this.gridConnections.forEach(GridConnection::draw);
    }

    @Override
    public void setOrientation(ElementOrientation orientation) {
        super.setOrientation(orientation);
        this.gridConnections.forEach(it -> it.updateParentOrientation(orientation));
    }
}

